/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.xmlserializer;

import com.fifa.connectid.sdk.core.XmlDeserializationException;
import com.fifa.connectid.sdk.core.XmlSerializationException;
import com.fifa.connectid.sdk.core.xmlserializer.PersonLocalXmlSerializer;
import com.fifa.connectid.sdk.core.xsdschemavalidator.ValidationResult;
import com.fifa.connectid.sdk.core.xsdschemavalidator.XsdSchemaValidator;
import com.fifa.fc.LocalPersonNameType;
import com.fifa.fc.MatchOfficialRegistrationType;
import com.fifa.fc.NationalIdentifierType;
import com.fifa.fc.OrganisationOfficialRegistrationType;
import com.fifa.fc.PersonLocal;
import com.fifa.fc.PlayerRegistrationType;
import com.fifa.fc.RegistrationType;
import com.fifa.fc.TeamOfficialRegistrationType;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.xml.sax.SAXException;

public class PersonLocalXmlSerializerImpl
implements PersonLocalXmlSerializer {
    private XsdSchemaValidator xsdSchemaValidator = new XsdSchemaValidator();
    private final String contextPath = "com.fifa.fc";

    @Override
    public String serialize(PersonLocal personLocal) throws JAXBException, IOException, SAXException, XmlSerializationException {
        JAXBContext ctx = this.getPersonalLocalJAXBContext();
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", true);
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)personLocal, stringWriter);
        String xml = stringWriter.toString();
        stringWriter.close();
        ValidationResult validationResult = this.xsdSchemaValidator.validate(xml);
        if (!validationResult.isValid()) {
            throw new XmlSerializationException("PersonLocal to XML serialization failed for person: " + personLocal.getLocalLastName(), validationResult.getErrors(), xml);
        }
        return xml;
    }

    @Override
    public PersonLocal deserialize(String xml) throws XmlDeserializationException {
        try {
            JAXBContext ctx = this.getPersonalLocalJAXBContext();
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            PersonLocal personLocal = (PersonLocal)unmarshaller.unmarshal(new StringReader(xml));
            this.validateRequiredProperties(personLocal);
            return personLocal;
        }
        catch (Exception ex) {
            throw new XmlDeserializationException(xml, "XML to PersonLocal deserialization failed.", ex);
        }
    }

    private void validateRequiredProperties(PersonLocal personLocal) {
        if (personLocal.getPhoto() != null && personLocal.getPhoto().getPictureEmbedded() == null) {
            throw new IllegalArgumentException("pictureEmbedded cannot be null.");
        }
        for (LocalPersonNameType localName : personLocal.getLocalPersonNames()) {
            if (localName.getLastName() != null) continue;
            throw new IllegalArgumentException("localPersonLastName cannot be null.");
        }
        for (NationalIdentifierType nationalIdentifier : personLocal.getNationalIdentifiers()) {
            if (nationalIdentifier.getIdentifier() != null) continue;
            throw new IllegalArgumentException("nationalIdentifier cannot be null.");
        }
        this.ValidateRequiredPlayerRegistrationProperties(personLocal.getPlayerRegistrations());
        this.ValidateRequiredTeamOfficialRegistrationProperties(personLocal.getTeamOfficialRegistrations());
        this.ValidateRequiredMatchOfficialRegistrationProperties(personLocal.getMatchOfficialRegistrations());
        this.ValidateRequiredOrganisationOfficialRegistrationProperties(personLocal.getOrganisationOfficialRegistrations());
        if (personLocal.getLocalLastName() == null) {
            throw new IllegalArgumentException("localLastName cannot be null.");
        }
        if (personLocal.getLocalLanguage() == null) {
            throw new IllegalArgumentException("localLanguage cannot be null.");
        }
        if (personLocal.getGender() == null) {
            throw new IllegalArgumentException("gender cannot be null.");
        }
        if (personLocal.getNationality() == null) {
            throw new IllegalArgumentException("nationality cannot be null.");
        }
        if (personLocal.getDateOfBirth() == null) {
            throw new IllegalArgumentException("dateOfBirth cannot be null.");
        }
        if (personLocal.getPlaceOfBirth() == null) {
            throw new IllegalArgumentException("placeOfBirth cannot be null.");
        }
    }

    private void ValidateRequiredPlayerRegistrationProperties(List<PlayerRegistrationType> playerRegistrations) {
        for (PlayerRegistrationType playerRegistration : playerRegistrations) {
            this.ValidateRequiredRegistrationProperties((RegistrationType)playerRegistration);
        }
    }

    private void ValidateRequiredTeamOfficialRegistrationProperties(List<TeamOfficialRegistrationType> teamOfficialRegistrations) {
        for (TeamOfficialRegistrationType teamOfficialRegistration : teamOfficialRegistrations) {
            this.ValidateRequiredRegistrationProperties((RegistrationType)teamOfficialRegistration);
        }
    }

    private void ValidateRequiredMatchOfficialRegistrationProperties(List<MatchOfficialRegistrationType> matchOfficialRegistrations) {
        for (MatchOfficialRegistrationType matchOfficialRegistration : matchOfficialRegistrations) {
            this.ValidateRequiredRegistrationProperties((RegistrationType)matchOfficialRegistration);
        }
    }

    private void ValidateRequiredOrganisationOfficialRegistrationProperties(List<OrganisationOfficialRegistrationType> organisationOfficialRegistrations) {
        for (OrganisationOfficialRegistrationType organisationOfficialRegistration : organisationOfficialRegistrations) {
            this.ValidateRequiredRegistrationProperties((RegistrationType)organisationOfficialRegistration);
        }
    }

    private void ValidateRequiredRegistrationProperties(RegistrationType registration) {
        if (registration.getPersonFIFAId() == null) {
            throw new IllegalArgumentException("personFIFAId cannot be null.");
        }
        if (registration.getOrganisationFIFAId() == null) {
            throw new IllegalArgumentException("organisationFIFAId cannot be null");
        }
    }

    private JAXBContext getPersonalLocalJAXBContext() throws JAXBException {
        ClassLoader loader = PersonLocal.class.getClassLoader();
        return JAXBContext.newInstance(this.contextPath, loader);
    }
}

