/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.xsdschemavalidator;

import com.fifa.connectid.sdk.core.xsdschemavalidator.ValidationResult;
import com.fifa.connectid.sdk.core.xsdschemavalidator.XmlValidationError;
import com.fifa.connectid.sdk.core.xsdschemavalidator.XsdResourceResolver;
import com.fifa.connectid.sdk.core.xsdschemavalidator.XsdSchemasDirectoryResolver;
import com.fifa.connectid.sdk.util.ResourcePath;
import com.fifa.connectid.sdk.util.ResourceReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.LinkedList;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XsdSchemaValidator {
    private static final String xsdSchemaDirectory = new XsdSchemasDirectoryResolver().getDirectory();

    public ValidationResult validate(String xml) throws SAXException, IOException {
        Schema schema = this.createSchema();
        StreamSource xmlSource = new StreamSource(new StringReader(xml));
        Validator validator = schema.newValidator();
        final LinkedList errors = new LinkedList();
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
                errors.add(new XmlValidationError(exception));
            }

            @Override
            public void fatalError(SAXParseException exception) {
                errors.add(new XmlValidationError(exception));
            }

            @Override
            public void error(SAXParseException exception) {
                errors.add(new XmlValidationError(exception));
            }
        });
        validator.validate(xmlSource);
        return new ValidationResult(errors.toArray(new XmlValidationError[errors.size()]));
    }

    private Schema createSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String xsdSchemaFile = "scenarios.xsd";
        InputStream stream = new ResourceReader().readToStream(new ResourcePath(xsdSchemaDirectory, "scenarios.xsd"));
        StreamSource scenariosXsd = new StreamSource(stream);
        schemaFactory.setResourceResolver(new XsdResourceResolver(xsdSchemaDirectory + "/"));
        return schemaFactory.newSchema(scenariosXsd);
    }
}

