/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.messageHandlers;

import com.fifa.connectid.sdk.EventHandler;
import com.fifa.connectid.sdk.RegistrationFacadeException;
import com.fifa.connectid.sdk.messageHandlers.MessageHandler;
import com.fifa.connectid.sdk.messageHandlers.MessageHandlerExtensions;
import com.fifa.connectservicebus.sdk.Message;

public class GenericMessageHandler
implements MessageHandler {
    private final EventHandler<Message> messageHandler;

    public GenericMessageHandler(EventHandler<Message> messageHandler) {
        this.messageHandler = messageHandler;
    }

    @Override
    public boolean canHandle(String messageType) {
        return true;
    }

    @Override
    public void handle(String messageType, Message message) throws RegistrationFacadeException {
        try {
            this.messageHandler.handle(message);
        }
        catch (Exception ex) {
            String errorMessage = String.format("Generic message with id: %s was not properly handled by the client.", message.getId());
            throw new RegistrationFacadeException(errorMessage, ex);
        }
    }

    public String toString() {
        return MessageHandlerExtensions.fullName(this);
    }
}

