/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.messageHandlers;

import com.fifa.connectid.sdk.CompositeErrorBuilder;
import com.fifa.connectid.sdk.EventHandler;
import com.fifa.connectid.sdk.PersonDetails;
import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.messageHandlers.MessageHandler;
import com.fifa.connectid.sdk.messageHandlers.MessageHandlerExtensions;
import com.fifa.connectservicebus.sdk.Message;
import com.fifa.connectservicebus.sdk.StringUtils;
import java.util.Objects;

public class PersonDetailsHandler
implements MessageHandler {
    private final EventHandler<PersonDetails> personDetailsHandler;

    public PersonDetailsHandler(EventHandler<PersonDetails> personDetailsHandler) {
        this.personDetailsHandler = personDetailsHandler;
    }

    @Override
    public boolean canHandle(String messageType) {
        return Objects.equals(messageType, "person-details");
    }

    @Override
    public void handle(String messageType, Message message) throws Exception {
        String sender = message.getSender();
        String[] senderChunks = sender.split("_");
        String correlationId = message.getProperty("correlationId");
        String errors = new CompositeErrorBuilder().addMessageForCase(StringUtils.isNullOrEmpty((String)sender), "The 'Sender' property cannot be null or empty in person details message.").addMessageForCase(StringUtils.isNullOrEmpty((String)correlationId), "The 'correlationId' property cannot be null or empty in person details message.").build();
        if (errors != null) {
            throw new ValidationException(errors);
        }
        String xmlData = message.getContent().length > 0 ? new String(message.getContent()) : null;
        PersonDetails personDetails = new PersonDetails(senderChunks[0], xmlData, correlationId);
        this.personDetailsHandler.handle(personDetails);
    }

    public String toString() {
        return MessageHandlerExtensions.fullNameWithMessageType(this, "person-details");
    }
}

