/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.messageHandlers;

import com.fifa.connectid.sdk.CompositeErrorBuilder;
import com.fifa.connectid.sdk.EventHandler;
import com.fifa.connectid.sdk.PersonDetailsRequest;
import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.messageHandlers.MessageHandler;
import com.fifa.connectid.sdk.messageHandlers.MessageHandlerExtensions;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusException;
import com.fifa.connectservicebus.sdk.Message;
import com.fifa.connectservicebus.sdk.StringUtils;
import java.util.Objects;

public class PersonDetailsRequestHandler
implements MessageHandler {
    private final EventHandler<PersonDetailsRequest> personDetailsRequestHandler;
    private final EventHandler<FifaConnectServiceBusException> exceptionHandler;

    public PersonDetailsRequestHandler(EventHandler<PersonDetailsRequest> personDetailsRequestHandler, EventHandler<FifaConnectServiceBusException> exceptionHandler) {
        this.personDetailsRequestHandler = personDetailsRequestHandler;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public boolean canHandle(String messageType) {
        return Objects.equals(messageType, "person-details-request");
    }

    @Override
    public void handle(String messageType, Message message) throws Exception {
        String replyTo = message.getReplyTo();
        String uniqueFifaId = message.getProperty("uniqueFifaId");
        String correlationId = message.getProperty("correlationId");
        String errors = new CompositeErrorBuilder().addMessageForCase(StringUtils.isNullOrEmpty((String)replyTo), "The 'ReplyTo' property cannot be null or empty in a person details request message.").addMessageForCase(StringUtils.isNullOrEmpty((String)uniqueFifaId), "The 'uniqueFifaId' property cannot be null or empty in a person details request message.").addMessageForCase(StringUtils.isNullOrEmpty((String)correlationId), "The 'correlationId' property cannot be null or empty in a person details request message.").build();
        if (errors != null) {
            throw new ValidationException(errors);
        }
        PersonDetailsRequest personDetailsRequest = new PersonDetailsRequest(replyTo, uniqueFifaId, correlationId, message);
        try {
            this.personDetailsRequestHandler.handle(personDetailsRequest);
        }
        catch (FifaConnectServiceBusException ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    public String toString() {
        return MessageHandlerExtensions.fullNameWithMessageType(this, "person-details-request");
    }
}

