/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.notifications;

import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.FifaIdValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ValidationConstants;
import com.fifa.connectid.sdk.messageHandlers.MessageHandler;
import com.fifa.connectid.sdk.messageHandlers.MessageHandlerExtensions;
import com.fifa.connectid.sdk.notifications.DateOfBirthChangedNotification;
import com.fifa.connectid.sdk.notifications.DateOfBirthChangedNotificationDto;
import com.fifa.connectid.sdk.notifications.DateOfBirthChangedNotificationDtoToModelConverter;
import com.fifa.connectid.sdk.notifications.DateOfBirthChangedNotificationHandler;
import com.fifa.connectid.sdk.notifications.DatesConverter;
import com.fifa.connectid.sdk.notifications.MessageToDtoConverter;
import com.fifa.connectservicebus.sdk.Message;
import java.time.LocalDate;

public class DateOfBirthChangedMessageHandler
implements MessageHandler {
    private static final String SUPPORTED_MESSAGE_TYPE = "date-of-birth-changed-notification";
    private final DateOfBirthChangedNotificationHandler notificationHandler;
    private final ModelValidator<DateOfBirthChangedNotificationDto> dtoValidator;
    private final MessageToDtoConverter<DateOfBirthChangedNotificationDto> messageToDtoConverter;

    public DateOfBirthChangedMessageHandler(DateOfBirthChangedNotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
        this.messageToDtoConverter = new MessageToDtoConverter<DateOfBirthChangedNotificationDto>(DateOfBirthChangedNotificationDto.class);
        LocalDate dateOfBirthLowerBoundary = DatesConverter.toLocalDate(ValidationConstants.DATE_OF_BIRTH_LOWER_BOUNDARY);
        this.dtoValidator = (validationSubject, validationSubjectName) -> {
            new FifaIdValidator().validate(validationSubject.getPersonFIFAId(), "personFIFAId");
            ApiModelValidator.mustBeGreaterOrEqual(DatesConverter.toLocalDate(validationSubject.getBefore()), dateOfBirthLowerBoundary, "before");
            ApiModelValidator.mustBeGreaterOrEqual(DatesConverter.toLocalDate(validationSubject.getAfter()), dateOfBirthLowerBoundary, "after");
            ApiModelValidator.cannotBeNullOrWhitespace(validationSubject.getActorName(), "actorName");
        };
    }

    @Override
    public boolean canHandle(String messageType) {
        return SUPPORTED_MESSAGE_TYPE.equals(messageType);
    }

    @Override
    public void handle(String messageType, Message message) throws Exception {
        DateOfBirthChangedNotificationDto dto = this.messageToDtoConverter.convert(message);
        this.dtoValidator.validate(dto, "dto");
        DateOfBirthChangedNotification model = DateOfBirthChangedNotificationDtoToModelConverter.convert(dto);
        this.notificationHandler.handle(model);
    }

    public String toString() {
        return MessageHandlerExtensions.fullNameWithMessageType(this, SUPPORTED_MESSAGE_TYPE);
    }
}

