/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.notifications;

import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.FifaIdValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.connectid.sdk.messageHandlers.MessageHandler;
import com.fifa.connectid.sdk.messageHandlers.MessageHandlerExtensions;
import com.fifa.connectid.sdk.notifications.MessageToDtoConverter;
import com.fifa.connectid.sdk.notifications.PersonMergedNotification;
import com.fifa.connectid.sdk.notifications.PersonMergedNotificationDto;
import com.fifa.connectid.sdk.notifications.PersonMergedNotificationDtoToModelConverter;
import com.fifa.connectid.sdk.notifications.PersonMergedNotificationHandler;
import com.fifa.connectservicebus.sdk.Message;

public class PersonMergedMessageHandler
implements MessageHandler {
    private static final String SUPPORTED_MESSAGE_TYPE = "person-merged-notification";
    private final PersonMergedNotificationHandler notificationHandler;
    private final ModelValidator<PersonMergedNotificationDto> dtoValidator;
    private final MessageToDtoConverter<PersonMergedNotificationDto> messageToDtoConverter;

    public PersonMergedMessageHandler(PersonMergedNotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
        this.messageToDtoConverter = new MessageToDtoConverter<PersonMergedNotificationDto>(PersonMergedNotificationDto.class);
        FifaIdValidator fifaIdValidator = new FifaIdValidator();
        this.dtoValidator = (validationSubject, validationSubjectName) -> {
            fifaIdValidator.validate(validationSubject.getPrimaryPersonFIFAId(), "primaryPersonFIFAId");
            fifaIdValidator.validate(validationSubject.getSecondaryPersonFIFAId(), "secondaryPersonFIFAId");
            ApiModelValidator.cannotBeNullOrWhitespace(validationSubject.getActorName(), "actorName");
        };
    }

    @Override
    public boolean canHandle(String messageType) {
        return SUPPORTED_MESSAGE_TYPE.equals(messageType);
    }

    @Override
    public void handle(String messageType, Message message) throws Exception {
        PersonMergedNotificationDto dto = this.messageToDtoConverter.convert(message);
        this.dtoValidator.validate(dto, "dto");
        PersonMergedNotification model = PersonMergedNotificationDtoToModelConverter.convert(dto);
        this.notificationHandler.handle(model);
    }

    public String toString() {
        return MessageHandlerExtensions.fullNameWithMessageType(this, SUPPORTED_MESSAGE_TYPE);
    }
}

