/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.notifications;

import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.FifaIdValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.connectid.sdk.messageHandlers.MessageHandler;
import com.fifa.connectid.sdk.messageHandlers.MessageHandlerExtensions;
import com.fifa.connectid.sdk.notifications.MessageToDtoConverter;
import com.fifa.connectid.sdk.notifications.PersonNameChangedNotification;
import com.fifa.connectid.sdk.notifications.PersonNameChangedNotificationDto;
import com.fifa.connectid.sdk.notifications.PersonNameChangedNotificationDtoToModelConverter;
import com.fifa.connectid.sdk.notifications.PersonNameChangedNotificationHandler;
import com.fifa.connectservicebus.sdk.Message;

public class PersonNameChangedMessageHandler
implements MessageHandler {
    private static final String SUPPORTED_MESSAGE_TYPE = "person-name-changed-notification";
    private final PersonNameChangedNotificationHandler notificationHandler;
    private final ModelValidator<PersonNameChangedNotificationDto> dtoValidator;
    private final MessageToDtoConverter<PersonNameChangedNotificationDto> messageToDtoConverter;

    public PersonNameChangedMessageHandler(PersonNameChangedNotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
        this.messageToDtoConverter = new MessageToDtoConverter<PersonNameChangedNotificationDto>(PersonNameChangedNotificationDto.class);
        FifaIdValidator fifaIdValidator = new FifaIdValidator();
        this.dtoValidator = (validationSubject, validationSubjectName) -> {
            fifaIdValidator.validate(validationSubject.getPersonFIFAId(), "personFIFAId");
            ApiModelValidator.cannotBeNullOrWhitespace(validationSubject.getActorName(), "actorName");
        };
    }

    @Override
    public boolean canHandle(String messageType) {
        return SUPPORTED_MESSAGE_TYPE.equals(messageType);
    }

    @Override
    public void handle(String messageType, Message message) throws Exception {
        PersonNameChangedNotificationDto dto = this.messageToDtoConverter.convert(message);
        this.dtoValidator.validate(dto, "dto");
        PersonNameChangedNotification model = PersonNameChangedNotificationDtoToModelConverter.convert(dto);
        this.notificationHandler.handle(model);
    }

    public String toString() {
        return MessageHandlerExtensions.fullNameWithMessageType(this, SUPPORTED_MESSAGE_TYPE);
    }
}

