/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.tms;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.fc.FirstProRegistration;
import com.fifa.fc.PersonLocal;
import com.fifa.fc.PlayerRegistrationType;
import com.fifa.fc.RegistrationLevelType;
import java.util.List;

public class FirstProRegistrationValidator {
    public static void validate(FirstProRegistration firstProRegistration) throws ValidationException {
        if (firstProRegistration.getMessageId() == null) {
            throw new ValidationException("MessageId is missing");
        }
        PersonLocal player = firstProRegistration.getPlayer();
        if (player == null) {
            throw new ValidationException("Player is missing");
        }
        List playerRegistrations = player.getPlayerRegistrations();
        if (playerRegistrations.size() != 1) {
            throw new ValidationException("There must be exactly one player registration provided");
        }
        if (!player.getOrganisationOfficialRegistrations().isEmpty()) {
            throw new ValidationException("There should be no organization registrations");
        }
        if (!player.getMatchOfficialRegistrations().isEmpty()) {
            throw new ValidationException("There should be no match official registrations");
        }
        if (!player.getTeamOfficialRegistrations().isEmpty()) {
            throw new ValidationException("There should be no team official registrations");
        }
        PlayerRegistrationType playerRegistration = (PlayerRegistrationType)playerRegistrations.get(0);
        if (playerRegistration.getLevel() != RegistrationLevelType.PRO) {
            throw new ValidationException("Only professional registrations are accepted");
        }
        if (playerRegistration.getClubTrainingCategory() == null) {
            throw new ValidationException("Club training category must be provided");
        }
    }
}

