/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.tms;

import com.fifa.connectid.sdk.core.exceptions.TmsOperationException;
import com.fifa.connectid.sdk.core.xmlserializer.JaxbXmlSerializer;
import com.fifa.connectid.sdk.core.xmlserializer.ValidatingXmlSerializer;
import com.fifa.connectid.sdk.tms.DomesticTransferDeclarationValidator;
import com.fifa.connectid.sdk.tms.FirstProRegistrationValidator;
import com.fifa.connectid.sdk.tms.PersonLocalToStringXmlSerializerAdapter;
import com.fifa.connectid.sdk.tms.ProofOfPaymentValidator;
import com.fifa.connectid.sdk.tms.TmsClient;
import com.fifa.connectid.sdk.tms.TmsOperation;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusClient;
import com.fifa.connectservicebus.sdk.logging.Logger;
import com.fifa.fc.DomesticTransferDeclaration;
import com.fifa.fc.FirstProRegistration;
import com.fifa.fc.PersonLocal;
import com.fifa.fc.ProofOfPayment;
import java.util.function.Function;

public class TmsClientImpl
implements TmsClient {
    private final TmsOperation<PersonLocal> personOperation;
    private final TmsOperation<DomesticTransferDeclaration> domesticTransferDeclarationOperation;
    private final TmsOperation<ProofOfPayment> proofOfPaymentOperation;
    private final TmsOperation<FirstProRegistration> firstProRegistrationOperation;

    public TmsClientImpl(FifaConnectServiceBusClient fifaConnectServiceBusClient, Logger logger) {
        this.personOperation = new TmsOperation<PersonLocal>(fifaConnectServiceBusClient, (requestType, personLocal) -> {
            if (personLocal == null) {
                throw new IllegalArgumentException("personLocal cannot be null");
            }
            if (personLocal.getPersonFIFAId() == null) {
                throw new IllegalArgumentException(String.format("Property PersonFIFAId cannot be null when sending '%s' TMS request", requestType));
            }
        }, new PersonLocalToStringXmlSerializerAdapter(), personLocal -> String.format("PersonLocal (FIFA_ID = %s)", personLocal.getPersonFIFAId()), logger);
        Function<DomesticTransferDeclaration, String> declarationToString = new Function<DomesticTransferDeclaration, String>(){

            @Override
            public String apply(DomesticTransferDeclaration declaration) {
                return String.format("DTD (Player's FIFA_ID = %s)", declaration.getPersonLocal().getPersonFIFAId());
            }
        };
        this.domesticTransferDeclarationOperation = new TmsOperation<DomesticTransferDeclaration>(fifaConnectServiceBusClient, (requestType, declaration) -> {
            PersonLocal personLocal = declaration.getPersonLocal();
            if (personLocal == null) {
                throw new IllegalArgumentException("personLocal cannot be null");
            }
            if (personLocal.getPersonFIFAId() == null) {
                throw new IllegalArgumentException(String.format("Property PersonFIFAId cannot be null when sending '%s' TMS request", requestType));
            }
            DomesticTransferDeclarationValidator.validate(declaration);
        }, new ValidatingXmlSerializer<DomesticTransferDeclaration>(new JaxbXmlSerializer<DomesticTransferDeclaration>(DomesticTransferDeclaration.class), declarationToString), declarationToString, logger);
        Function<ProofOfPayment, String> proofOfPaymentToString = new Function<ProofOfPayment, String>(){

            @Override
            public String apply(ProofOfPayment proofOfPayment) {
                return String.format("ProofOfPayment (TMS Transfer ID = %s, PaymentType = %s)", proofOfPayment.getTmsTransferId(), proofOfPayment.getPaymentType());
            }
        };
        this.proofOfPaymentOperation = new TmsOperation<ProofOfPayment>(fifaConnectServiceBusClient, (requestType, proofOfPayment) -> {
            if (proofOfPayment == null) {
                throw new IllegalArgumentException("proofOfPayment cannot be null");
            }
            ProofOfPaymentValidator.validate(proofOfPayment);
        }, new ValidatingXmlSerializer<ProofOfPayment>(new JaxbXmlSerializer<ProofOfPayment>(ProofOfPayment.class), proofOfPaymentToString), proofOfPaymentToString, logger);
        Function<FirstProRegistration, String> firstProRegistrationToString = new Function<FirstProRegistration, String>(){

            @Override
            public String apply(FirstProRegistration firstProRegistration) {
                return String.format("FirstProRegistration (Player's FIFA_ID = %s, Club's FIFA_ID = %s)", firstProRegistration.getPlayer().getPersonFIFAId(), firstProRegistration.getClub().getClubFIFAId());
            }
        };
        this.firstProRegistrationOperation = new TmsOperation<FirstProRegistration>(fifaConnectServiceBusClient, (requestType, firstProRegistration) -> {
            if (firstProRegistration == null) {
                throw new IllegalArgumentException("firstProRegistration cannot be null");
            }
            FirstProRegistrationValidator.validate(firstProRegistration);
        }, new ValidatingXmlSerializer<FirstProRegistration>(new JaxbXmlSerializer<FirstProRegistration>(FirstProRegistration.class), firstProRegistrationToString), firstProRegistrationToString, logger);
    }

    @Override
    public void addPlayer(String correlationId, PersonLocal personLocal) throws TmsOperationException {
        this.personOperation.sendRequest(correlationId, "add-player", personLocal);
    }

    @Override
    public void updatePlayer(String correlationId, PersonLocal personLocal) throws TmsOperationException {
        this.personOperation.sendRequest(correlationId, "update-player", personLocal);
    }

    @Override
    public void declareDomesticTransfer(String correlationId, DomesticTransferDeclaration declaration) throws TmsOperationException {
        this.domesticTransferDeclarationOperation.sendRequest(correlationId, "domestic-transfer-declaration", declaration);
    }

    @Override
    public void provePayment(String correlationId, ProofOfPayment proofOfPayment) throws TmsOperationException {
        this.proofOfPaymentOperation.sendRequest(correlationId, "proof-of-payment", proofOfPayment);
    }

    @Override
    public void declareFirstProRegistration(String correlationId, FirstProRegistration firstProRegistration) throws TmsOperationException {
        this.firstProRegistrationOperation.sendRequest(correlationId, "first-pro-registration", firstProRegistration);
    }
}

