/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.tms;

import com.fifa.connectid.sdk.CorrelationIdBasedItemProvider;
import com.fifa.connectid.sdk.DeserializingCorrelationIdBasedItemProvider;
import com.fifa.connectid.sdk.MessageReceived;
import com.fifa.connectid.sdk.ResponseAwaiter;
import com.fifa.connectid.sdk.ResponseAwaiterFactory;
import com.fifa.connectid.sdk.core.exceptions.TmsOperationException;
import com.fifa.connectid.sdk.tms.DeclarationRejectedException;
import com.fifa.connectid.sdk.tms.DomesticTransferDeclarationResponseSerializerFactory;
import com.fifa.connectid.sdk.tms.FirstProRegistrationResponseSerializerFactory;
import com.fifa.connectid.sdk.tms.ProofOfPaymentResponseSerializerFactory;
import com.fifa.connectid.sdk.tms.ResponseNotReceivedException;
import com.fifa.connectid.sdk.tms.TmsClient;
import com.fifa.connectid.sdk.tms.TmsClientImpl;
import com.fifa.connectid.sdk.tms.TmsFacade;
import com.fifa.connectid.sdk.util.CorrelationId;
import com.fifa.connectid.sdk.util.CorrelationIdFormatter;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusClient;
import com.fifa.connectservicebus.sdk.logging.Logger;
import com.fifa.fc.DomesticTransferDeclaration;
import com.fifa.fc.DomesticTransferDeclarationResponse;
import com.fifa.fc.ErrorType;
import com.fifa.fc.FirstProRegistration;
import com.fifa.fc.FirstProRegistrationResponse;
import com.fifa.fc.PersonLocal;
import com.fifa.fc.ProofOfPayment;
import com.fifa.fc.ProofOfPaymentResponse;
import java.time.Duration;

public class TmsFacadeImpl
implements TmsFacade {
    private final TmsClient tmsClient;
    private final Logger logger;
    private final ResponseAwaiterFactory responseAwaiterFactory;
    private final CorrelationIdBasedItemProvider<DomesticTransferDeclarationResponse> domesticTransferDeclarationResponseCache;
    private final CorrelationIdBasedItemProvider<FirstProRegistrationResponse> firstProRegistrationResponseCache;
    private final CorrelationIdBasedItemProvider<ProofOfPaymentResponse> proofOfPaymentConfirmationResponseCache;

    public TmsFacadeImpl(TmsClient tmsClient, Logger logger, ResponseAwaiterFactory responseAwaiterFactory, CorrelationIdBasedItemProvider<DomesticTransferDeclarationResponse> domesticTransferDeclarationResponseCache, CorrelationIdBasedItemProvider<FirstProRegistrationResponse> firstProRegistrationResponseCache, CorrelationIdBasedItemProvider<ProofOfPaymentResponse> proofOfPaymentConfirmationResponseCache) {
        this.tmsClient = tmsClient;
        this.logger = logger;
        this.responseAwaiterFactory = responseAwaiterFactory;
        this.domesticTransferDeclarationResponseCache = domesticTransferDeclarationResponseCache;
        this.firstProRegistrationResponseCache = firstProRegistrationResponseCache;
        this.proofOfPaymentConfirmationResponseCache = proofOfPaymentConfirmationResponseCache;
    }

    public TmsFacadeImpl(FifaConnectServiceBusClient fifaConnectServiceBusClient, Logger logger, ResponseAwaiterFactory responseAwaiterFactory, CorrelationIdBasedItemProvider<MessageReceived> confirmationsCache) {
        this(new TmsClientImpl(fifaConnectServiceBusClient, logger), logger, responseAwaiterFactory, new DeserializingCorrelationIdBasedItemProvider<MessageReceived, DomesticTransferDeclarationResponse>(confirmationsCache, DomesticTransferDeclarationResponseSerializerFactory.create()), new DeserializingCorrelationIdBasedItemProvider<MessageReceived, FirstProRegistrationResponse>(confirmationsCache, FirstProRegistrationResponseSerializerFactory.create()), new DeserializingCorrelationIdBasedItemProvider<MessageReceived, ProofOfPaymentResponse>(confirmationsCache, ProofOfPaymentResponseSerializerFactory.create()));
    }

    @Override
    public String addPlayer(PersonLocal personLocal) throws TmsOperationException {
        String correlationId = CorrelationId.create();
        try {
            this.tmsClient.addPlayer(correlationId, personLocal);
            return correlationId;
        }
        catch (Exception e) {
            this.logger.error(e, CorrelationIdFormatter.format(correlationId) + "Failed to add player", new Object[0]);
            throw e;
        }
    }

    @Override
    public String updatePlayer(PersonLocal personLocal) throws TmsOperationException {
        String correlationId = CorrelationId.create();
        try {
            this.tmsClient.updatePlayer(correlationId, personLocal);
            return correlationId;
        }
        catch (Exception e) {
            this.logger.error(e, CorrelationIdFormatter.format(correlationId) + "Failed to update player", new Object[0]);
            throw e;
        }
    }

    @Override
    public long declareDomesticTransferAndWaitForTransferId(DomesticTransferDeclaration declaration, Duration timeout2) throws Exception {
        String correlationId = CorrelationId.create();
        try {
            ResponseAwaiter<DomesticTransferDeclarationResponse> responseAwaiter = this.responseAwaiterFactory.create(this.domesticTransferDeclarationResponseCache);
            this.tmsClient.declareDomesticTransfer(correlationId, declaration);
            DomesticTransferDeclarationResponse response = responseAwaiter.waitForResponse(correlationId, timeout2);
            if (response == null) {
                throw new ResponseNotReceivedException("Transfer ID has not arrived within the specified timeout", correlationId);
            }
            ErrorType error = response.getError();
            if (error != null) {
                throw new DeclarationRejectedException("Domestic Transfer Declaration", error.getMessage());
            }
            return response.getConfirmation().getTmsTransferId();
        }
        catch (Exception e) {
            this.logger.error(e, CorrelationIdFormatter.format(correlationId) + "Failed to send Domestic Transfer Declaration", new Object[0]);
            throw e;
        }
    }

    @Override
    public long provePaymentAndWaitForPaymentId(ProofOfPayment proofOfPayment, Duration timeout2) throws Exception {
        String correlationId = CorrelationId.create();
        try {
            ResponseAwaiter<ProofOfPaymentResponse> responseAwaiter = this.responseAwaiterFactory.create(this.proofOfPaymentConfirmationResponseCache);
            this.tmsClient.provePayment(correlationId, proofOfPayment);
            ProofOfPaymentResponse response = responseAwaiter.waitForResponse(correlationId, timeout2);
            if (response == null) {
                throw new ResponseNotReceivedException("Payment ID has not arrived within the specified timeout", correlationId);
            }
            ErrorType error = response.getError();
            if (error != null) {
                throw new DeclarationRejectedException("Proof Of Payment", error.getMessage());
            }
            return response.getConfirmation().getPaymentId();
        }
        catch (Exception e) {
            this.logger.error(e, CorrelationIdFormatter.format(correlationId) + "Failed to send Proof Of Payment", new Object[0]);
            throw e;
        }
    }

    @Override
    public long declareFirstProRegistrationAndWaitForRegistrationId(FirstProRegistration firstProRegistration, Duration timeout2) throws Exception {
        String correlationId = CorrelationId.create();
        try {
            ResponseAwaiter<FirstProRegistrationResponse> responseAwaiter = this.responseAwaiterFactory.create(this.firstProRegistrationResponseCache);
            this.tmsClient.declareFirstProRegistration(correlationId, firstProRegistration);
            FirstProRegistrationResponse response = responseAwaiter.waitForResponse(correlationId, timeout2);
            if (response == null) {
                throw new ResponseNotReceivedException("First Registration ID has not arrived within the specified timeout", correlationId);
            }
            ErrorType error = response.getError();
            if (error != null) {
                throw new DeclarationRejectedException("First Pro Registration", error.getMessage());
            }
            return response.getConfirmation().getTmsFirstRegistrationId();
        }
        catch (Exception e) {
            this.logger.error(e, CorrelationIdFormatter.format(correlationId) + "Failed to send First Pro Registration", new Object[0]);
            throw e;
        }
    }
}

