/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateTimeRfc1123 {
    private static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormat.forPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZoneUTC().withLocale(Locale.US);
    private final DateTime dateTime;

    public DateTimeRfc1123(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    public DateTimeRfc1123(String formattedString) {
        this.dateTime = DateTime.parse(formattedString, RFC1123_DATE_TIME_FORMATTER);
    }

    public DateTime dateTime() {
        if (this.dateTime == null) {
            return null;
        }
        return this.dateTime;
    }

    public String toString() {
        return RFC1123_DATE_TIME_FORMATTER.print(this.dateTime);
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeRfc1123)) {
            return false;
        }
        DateTimeRfc1123 rhs = (DateTimeRfc1123)obj;
        return this.dateTime.equals(rhs.dateTime());
    }
}

