/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ExpandableStringEnum<T extends ExpandableStringEnum<T>> {
    private static ConcurrentMap<String, ? extends ExpandableStringEnum<?>> valuesByName = null;
    private String name;
    private Class<T> clazz;

    private static String uniqueKey(Class<?> clazz, String name) {
        if (clazz != null) {
            return (clazz.getName() + "#" + name).toLowerCase();
        }
        throw new IllegalArgumentException();
    }

    protected T withNameValue(String name, T value, Class<T> clazz) {
        if (valuesByName == null) {
            valuesByName = new ConcurrentHashMap();
        }
        this.name = name;
        this.clazz = clazz;
        valuesByName.put(ExpandableStringEnum.uniqueKey(clazz, name), (ExpandableStringEnum<?>)value);
        return (T)this;
    }

    protected static <T extends ExpandableStringEnum<T>> T fromString(String name, Class<T> clazz) {
        ExpandableStringEnum value;
        if (name == null) {
            return null;
        }
        if (valuesByName != null && (value = (ExpandableStringEnum)valuesByName.get(ExpandableStringEnum.uniqueKey(clazz, name))) != null) {
            return (T)value;
        }
        try {
            value = (ExpandableStringEnum)clazz.newInstance();
            return (T)value.withNameValue(name, value, clazz);
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    protected static <T extends ExpandableStringEnum<T>> Collection<T> values(Class<T> clazz) {
        ArrayList values2 = new ArrayList(valuesByName.values());
        HashSet<ExpandableStringEnum> list = new HashSet<ExpandableStringEnum>();
        for (ExpandableStringEnum value : values2) {
            if (!value.getClass().isAssignableFrom(clazz)) continue;
            list.add(value);
        }
        return list;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return ExpandableStringEnum.uniqueKey(this.clazz, this.name).hashCode();
    }

    public boolean equals(Object obj) {
        if (!this.clazz.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.name == null) {
            return ((ExpandableStringEnum)obj).name == null;
        }
        return this.name.equals(((ExpandableStringEnum)obj).name);
    }
}

