/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;

public final class ServiceResponseBuilder<T, E extends RestException>
implements ResponseBuilder<T, E> {
    private final Map<Integer, Type> responseTypes;
    private Class<? extends RestException> exceptionType;
    private final SerializerAdapter<?> serializerAdapter;
    private boolean throwOnGet404;

    private ServiceResponseBuilder(SerializerAdapter<?> serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        this.responseTypes = new HashMap<Integer, Type>();
        this.exceptionType = RestException.class;
        this.responseTypes.put(0, (Type)((Object)Object.class));
        this.throwOnGet404 = false;
    }

    @Override
    public ServiceResponseBuilder<T, E> register(int statusCode, Type type) {
        this.responseTypes.put(statusCode, type);
        return this;
    }

    @Override
    public ServiceResponseBuilder<T, E> registerError(Class<? extends RestException> type) {
        this.exceptionType = type;
        try {
            Method f = type.getDeclaredMethod("body", new Class[0]);
            this.responseTypes.put(0, f.getReturnType());
        }
        catch (NoSuchMethodException e) {
            this.responseTypes.put(0, (Type)((Object)Object.class));
        }
        return this;
    }

    public ServiceResponseBuilder<T, E> registerAll(Map<Integer, Type> responseTypes) {
        this.responseTypes.putAll(responseTypes);
        return this;
    }

    @Override
    public ServiceResponse<T> build(Response<ResponseBody> response) throws IOException {
        if (response == null) {
            return null;
        }
        int statusCode = response.code();
        ResponseBody responseBody = response.isSuccessful() ? response.body() : response.errorBody();
        if (this.responseTypes.containsKey(statusCode)) {
            return new ServiceResponse<Object>(this.buildBody(statusCode, responseBody), response);
        }
        if (response.isSuccessful() && this.responseTypes.size() == 1) {
            return new ServiceResponse<Object>(this.buildBody(statusCode, responseBody), response);
        }
        if (!this.throwOnGet404 && "GET".equals(response.raw().request().method()) && statusCode == 404) {
            return new ServiceResponse<Object>(null, response);
        }
        try {
            String responseContent = "";
            if (responseBody != null) {
                responseContent = responseBody.source().buffer().clone().readUtf8();
            }
            throw this.exceptionType.getConstructor(String.class, Response.class, (Class)this.responseTypes.get(0)).newInstance("Status code " + statusCode + ", " + responseContent, response, this.buildBody(statusCode, responseBody));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Status code " + statusCode + ", but an instance of " + this.exceptionType.getCanonicalName() + " cannot be created.", e);
        }
    }

    @Override
    public ServiceResponse<T> buildEmpty(Response<Void> response) throws IOException {
        int statusCode = response.code();
        if (this.responseTypes.containsKey(statusCode)) {
            return new ServiceResponse(response);
        }
        if (response.isSuccessful() && this.responseTypes.size() == 1) {
            return new ServiceResponse(response);
        }
        try {
            throw this.exceptionType.getConstructor(String.class, Response.class).newInstance("Status code " + statusCode, response);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Status code " + statusCode + ", but an instance of " + this.exceptionType.getCanonicalName() + " cannot be created.", e);
        }
    }

    @Override
    public <THeader> ServiceResponseWithHeaders<T, THeader> buildWithHeaders(final Response<ResponseBody> response, Class<THeader> headerType) throws IOException {
        ServiceResponse<T> bodyResponse = this.build(response);
        Object headers = this.serializerAdapter.deserialize(this.serializerAdapter.serialize(Maps.asMap(response.headers().names(), new Function<String, String>(){

            @Override
            public String apply(String s2) {
                return response.headers().get(s2);
            }
        })), headerType);
        return new ServiceResponseWithHeaders(bodyResponse.body(), headers, bodyResponse.response());
    }

    @Override
    public <THeader> ServiceResponseWithHeaders<T, THeader> buildEmptyWithHeaders(final Response<Void> response, Class<THeader> headerType) throws IOException {
        ServiceResponse<T> bodyResponse = this.buildEmpty(response);
        Object headers = this.serializerAdapter.deserialize(this.serializerAdapter.serialize(Maps.asMap(response.headers().names(), new Function<String, String>(){

            @Override
            public String apply(String s2) {
                return response.headers().get(s2);
            }
        })), headerType);
        ServiceResponseWithHeaders serviceResponse = new ServiceResponseWithHeaders(headers, bodyResponse.headResponse());
        serviceResponse.withBody(bodyResponse.body());
        return serviceResponse;
    }

    private Object buildBody(int statusCode, ResponseBody responseBody) throws IOException {
        if (responseBody == null) {
            return null;
        }
        Type type = this.responseTypes.containsKey(statusCode) ? this.responseTypes.get(statusCode) : (this.responseTypes.get(0) != Object.class ? this.responseTypes.get(0) : new TypeReference<T>(){}.getType());
        if (type == Void.class) {
            return null;
        }
        if (type == InputStream.class) {
            return responseBody.byteStream();
        }
        String responseContent = responseBody.source().buffer().readUtf8();
        if (responseContent.length() <= 0) {
            return null;
        }
        return this.serializerAdapter.deserialize(responseContent, type);
    }

    public Class<? extends RestException> exceptionType() {
        return this.exceptionType;
    }

    public boolean isSuccessful(int statusCode) {
        return this.responseTypes != null && this.responseTypes.containsKey(statusCode);
    }

    public ServiceResponseBuilder<T, E> withThrowOnGet404(boolean throwOnGet404) {
        this.throwOnGet404 = throwOnGet404;
        return this;
    }

    public static final class Factory
    implements ResponseBuilder.Factory {
        public <T, E extends RestException> ServiceResponseBuilder<T, E> newInstance(SerializerAdapter<?> serializerAdapter) {
            return new ServiceResponseBuilder(serializerAdapter);
        }
    }
}

