/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.credentials;

import com.google.common.io.BaseEncoding;
import com.microsoft.rest.credentials.BasicAuthenticationCredentials;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

final class BasicAuthenticationCredentialsInterceptor
implements Interceptor {
    private BasicAuthenticationCredentials credentials;

    BasicAuthenticationCredentialsInterceptor(BasicAuthenticationCredentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        String auth = this.credentials.getUserName() + ":" + this.credentials.getPassword();
        auth = BaseEncoding.base64().encode(auth.getBytes("UTF8"));
        Request newRequest = chain.request().newBuilder().header("Authorization", "Basic " + auth).build();
        return chain.proceed(newRequest);
    }
}

