/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.interceptors;

import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class BaseUrlHandler
implements Interceptor {
    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String parameters = request.header("x-ms-parameterized-host");
        if (parameters != null && !parameters.isEmpty()) {
            String[] replacements = parameters.split(", ");
            if (replacements.length % 2 != 0) {
                throw new IllegalArgumentException("Must provide a replacement value for each pattern");
            }
            String baseUrl = request.url().toString();
            for (int i = 0; i < replacements.length; i += 2) {
                baseUrl = baseUrl.replaceAll("(?i)\\Q" + replacements[i] + "\\E", replacements[i + 1]);
            }
            baseUrl = this.removeRedundantProtocol(baseUrl);
            HttpUrl baseHttpUrl = HttpUrl.parse(baseUrl);
            request = request.newBuilder().url(baseHttpUrl).removeHeader("x-ms-parameterized-host").build();
        }
        return chain.proceed(request);
    }

    private String removeRedundantProtocol(String url) {
        int last;
        for (last = url.lastIndexOf("://") - 1; last >= 0 && Character.isLetter(url.charAt(last)); --last) {
        }
        return url.substring(last + 1);
    }
}

