/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.serializer;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.microsoft.rest.CollectionFormat;
import com.microsoft.rest.protocol.SerializerAdapter;
import com.microsoft.rest.serializer.AdditionalPropertiesDeserializer;
import com.microsoft.rest.serializer.AdditionalPropertiesSerializer;
import com.microsoft.rest.serializer.Base64UrlSerializer;
import com.microsoft.rest.serializer.ByteArraySerializer;
import com.microsoft.rest.serializer.DateTimeRfc1123Serializer;
import com.microsoft.rest.serializer.DateTimeSerializer;
import com.microsoft.rest.serializer.FlatteningDeserializer;
import com.microsoft.rest.serializer.FlatteningSerializer;
import com.microsoft.rest.serializer.HeadersSerializer;
import com.microsoft.rest.serializer.JacksonConverterFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class JacksonAdapter
implements SerializerAdapter<ObjectMapper> {
    private final ObjectMapper mapper;
    private final ObjectMapper simpleMapper = JacksonAdapter.initializeObjectMapper(new ObjectMapper());
    private JacksonConverterFactory converterFactory;

    public JacksonAdapter() {
        ObjectMapper flatteningMapper = JacksonAdapter.initializeObjectMapper(new ObjectMapper()).registerModule(FlatteningSerializer.getModule(this.simpleMapper())).registerModule(FlatteningDeserializer.getModule(this.simpleMapper()));
        this.mapper = JacksonAdapter.initializeObjectMapper(new ObjectMapper()).registerModule(AdditionalPropertiesSerializer.getModule(flatteningMapper)).registerModule(AdditionalPropertiesDeserializer.getModule(flatteningMapper)).registerModule(FlatteningSerializer.getModule(this.simpleMapper())).registerModule(FlatteningDeserializer.getModule(this.simpleMapper()));
    }

    protected ObjectMapper simpleMapper() {
        return this.simpleMapper;
    }

    @Override
    public ObjectMapper serializer() {
        return this.mapper;
    }

    @Override
    public JacksonConverterFactory converterFactory() {
        return JacksonConverterFactory.create(this.serializer());
    }

    @Override
    public String serialize(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        this.serializer().writeValue(writer, object);
        return writer.toString();
    }

    @Override
    public String serializeRaw(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return CharMatcher.is('\"').trimFrom(this.serialize(object));
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public String serializeList(List<?> list, CollectionFormat format) {
        if (list == null) {
            return null;
        }
        ArrayList<String> serialized = new ArrayList<String>();
        for (Object element : list) {
            String raw = this.serializeRaw(element);
            serialized.add(raw != null ? raw : "");
        }
        return Joiner.on(format.getDelimiter()).join(serialized);
    }

    private JavaType constructJavaType(Type type) {
        if (type instanceof ParameterizedType) {
            JavaType[] javaTypeArgs = new JavaType[((ParameterizedType)type).getActualTypeArguments().length];
            for (int i = 0; i != ((ParameterizedType)type).getActualTypeArguments().length; ++i) {
                javaTypeArgs[i] = this.constructJavaType(((ParameterizedType)type).getActualTypeArguments()[i]);
            }
            return this.mapper.getTypeFactory().constructType(type, TypeBindings.create((Class)((ParameterizedType)type).getRawType(), javaTypeArgs));
        }
        return this.mapper.getTypeFactory().constructType(type);
    }

    @Override
    public <T> T deserialize(String value, Type type) throws IOException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return this.serializer().readValue(value, this.constructJavaType(type));
    }

    private static ObjectMapper initializeObjectMapper(ObjectMapper mapper) {
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule(new JodaModule()).registerModule(ByteArraySerializer.getModule()).registerModule(Base64UrlSerializer.getModule()).registerModule(DateTimeSerializer.getModule()).registerModule(DateTimeRfc1123Serializer.getModule()).registerModule(HeadersSerializer.getModule());
        mapper.setVisibility((VisibilityChecker<?>)mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }
}

