/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.rxjava;

import retrofit2.Call;
import retrofit2.Response;
import retrofit2.adapter.rxjava.CallArbiter;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;

final class CallExecuteOnSubscribe<T>
implements Observable.OnSubscribe<Response<T>> {
    private final Call<T> originalCall;

    CallExecuteOnSubscribe(Call<T> originalCall) {
        this.originalCall = originalCall;
    }

    @Override
    public void call(Subscriber<? super Response<T>> subscriber) {
        Response<T> response;
        Call<T> call = this.originalCall.clone();
        CallArbiter<T> arbiter = new CallArbiter<T>(call, subscriber);
        subscriber.add(arbiter);
        subscriber.setProducer(arbiter);
        try {
            response = call.execute();
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal(t);
            arbiter.emitError(t);
            return;
        }
        arbiter.emitResponse(response);
    }
}

