/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.rxjava;

import java.lang.reflect.Type;
import javax.annotation.Nullable;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.adapter.rxjava.BodyOnSubscribe;
import retrofit2.adapter.rxjava.CallEnqueueOnSubscribe;
import retrofit2.adapter.rxjava.CallExecuteOnSubscribe;
import retrofit2.adapter.rxjava.Result;
import retrofit2.adapter.rxjava.ResultOnSubscribe;
import rx.Observable;
import rx.Scheduler;

final class RxJavaCallAdapter<R>
implements CallAdapter<R, Object> {
    private final Type responseType;
    @Nullable
    private final Scheduler scheduler;
    private final boolean isAsync;
    private final boolean isResult;
    private final boolean isBody;
    private final boolean isSingle;
    private final boolean isCompletable;

    RxJavaCallAdapter(Type responseType, @Nullable Scheduler scheduler, boolean isAsync, boolean isResult, boolean isBody, boolean isSingle, boolean isCompletable) {
        this.responseType = responseType;
        this.scheduler = scheduler;
        this.isAsync = isAsync;
        this.isResult = isResult;
        this.isBody = isBody;
        this.isSingle = isSingle;
        this.isCompletable = isCompletable;
    }

    @Override
    public Type responseType() {
        return this.responseType;
    }

    @Override
    public Object adapt(Call<R> call) {
        Observable.OnSubscribe<Response<R>> callFunc;
        Observable.OnSubscribe<Response<R>> onSubscribe = callFunc = this.isAsync ? new CallEnqueueOnSubscribe<R>(call) : new CallExecuteOnSubscribe<R>(call);
        Observable.OnSubscribe<Result<Object>> func = this.isResult ? new ResultOnSubscribe(callFunc) : (this.isBody ? new BodyOnSubscribe(callFunc) : callFunc);
        Observable observable2 = Observable.create(func);
        if (this.scheduler != null) {
            observable2 = observable2.subscribeOn(this.scheduler);
        }
        if (this.isSingle) {
            return observable2.toSingle();
        }
        if (this.isCompletable) {
            return observable2.toCompletable();
        }
        return observable2;
    }
}

