/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.NoSuchElementException;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func2;
import rx.plugins.RxJavaHooks;

public final class OnSubscribeReduce<T>
implements Observable.OnSubscribe<T> {
    final Observable<T> source;
    final Func2<T, T, T> reducer;

    public OnSubscribeReduce(Observable<T> source2, Func2<T, T, T> reducer) {
        this.source = source2;
        this.reducer = reducer;
    }

    @Override
    public void call(Subscriber<? super T> t) {
        final ReduceSubscriber<? super T> parent = new ReduceSubscriber<T>(t, this.reducer);
        t.add(parent);
        t.setProducer(new Producer(){

            @Override
            public void request(long n) {
                parent.downstreamRequest(n);
            }
        });
        this.source.unsafeSubscribe(parent);
    }

    static final class ReduceSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final Func2<T, T, T> reducer;
        T value;
        static final Object EMPTY = new Object();
        boolean done;

        public ReduceSubscriber(Subscriber<? super T> actual, Func2<T, T, T> reducer) {
            this.actual = actual;
            this.reducer = reducer;
            this.value = EMPTY;
            this.request(0L);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            T o = this.value;
            if (o == EMPTY) {
                this.value = t;
            } else {
                try {
                    this.value = this.reducer.call(o, t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.unsubscribe();
                    this.onError(ex);
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            if (!this.done) {
                this.done = true;
                this.actual.onError(e);
            } else {
                RxJavaHooks.onError(e);
            }
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.done = true;
            T o = this.value;
            if (o != EMPTY) {
                this.actual.onNext(o);
                this.actual.onCompleted();
            } else {
                this.actual.onError(new NoSuchElementException());
            }
        }

        void downstreamRequest(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required but it was " + n);
            }
            if (n != 0L) {
                this.request(Long.MAX_VALUE);
            }
        }
    }
}

