/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;

public final class OnSubscribeSkipTimed<T>
implements Observable.OnSubscribe<T> {
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Observable<T> source;

    public OnSubscribeSkipTimed(Observable<T> source2, long time, TimeUnit unit, Scheduler scheduler) {
        this.source = source2;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void call(Subscriber<? super T> child) {
        Scheduler.Worker worker = this.scheduler.createWorker();
        SkipTimedSubscriber<T> subscriber = new SkipTimedSubscriber<T>(child);
        subscriber.add(worker);
        child.add(subscriber);
        worker.schedule(subscriber, this.time, this.unit);
        this.source.unsafeSubscribe(subscriber);
    }

    static final class SkipTimedSubscriber<T>
    extends Subscriber<T>
    implements Action0 {
        final Subscriber<? super T> child;
        volatile boolean gate;

        SkipTimedSubscriber(Subscriber<? super T> child) {
            this.child = child;
        }

        @Override
        public void call() {
            this.gate = true;
        }

        @Override
        public void onNext(T t) {
            if (this.gate) {
                this.child.onNext(t);
            }
        }

        @Override
        public void onError(Throwable e) {
            try {
                this.child.onError(e);
            }
            finally {
                this.unsubscribe();
            }
        }

        @Override
        public void onCompleted() {
            try {
                this.child.onCompleted();
            }
            finally {
                this.unsubscribe();
            }
        }
    }
}

