/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.internal.operators.DeferredScalarSubscriberSafe;

public final class OnSubscribeToMap<T, K, V>
implements Observable.OnSubscribe<Map<K, V>>,
Func0<Map<K, V>> {
    final Observable<T> source;
    final Func1<? super T, ? extends K> keySelector;
    final Func1<? super T, ? extends V> valueSelector;
    final Func0<? extends Map<K, V>> mapFactory;

    public OnSubscribeToMap(Observable<T> source2, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        this(source2, keySelector, valueSelector, null);
    }

    public OnSubscribeToMap(Observable<T> source2, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, V>> mapFactory) {
        this.source = source2;
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.mapFactory = mapFactory == null ? this : mapFactory;
    }

    @Override
    public Map<K, V> call() {
        return new HashMap();
    }

    @Override
    public void call(Subscriber<? super Map<K, V>> subscriber) {
        Map<K, V> map;
        try {
            map = this.mapFactory.call();
        }
        catch (Throwable ex) {
            Exceptions.throwOrReport(ex, subscriber);
            return;
        }
        new ToMapSubscriber<T, K, V>(subscriber, map, this.keySelector, this.valueSelector).subscribeTo(this.source);
    }

    static final class ToMapSubscriber<T, K, V>
    extends DeferredScalarSubscriberSafe<T, Map<K, V>> {
        final Func1<? super T, ? extends K> keySelector;
        final Func1<? super T, ? extends V> valueSelector;

        ToMapSubscriber(Subscriber<? super Map<K, V>> actual, Map<K, V> map, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
            super(actual);
            this.value = map;
            this.hasValue = true;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            try {
                K key = this.keySelector.call(t);
                V val = this.valueSelector.call(t);
                ((Map)this.value).put(key, val);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(ex);
            }
        }
    }
}

