/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.internal.operators.DeferredScalarSubscriberSafe;

public final class OnSubscribeToMultimap<T, K, V>
implements Observable.OnSubscribe<Map<K, Collection<V>>>,
Func0<Map<K, Collection<V>>> {
    private final Func1<? super T, ? extends K> keySelector;
    private final Func1<? super T, ? extends V> valueSelector;
    private final Func0<? extends Map<K, Collection<V>>> mapFactory;
    private final Func1<? super K, ? extends Collection<V>> collectionFactory;
    private final Observable<T> source;

    public OnSubscribeToMultimap(Observable<T> source2, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        this(source2, keySelector, valueSelector, null, DefaultMultimapCollectionFactory.instance());
    }

    public OnSubscribeToMultimap(Observable<T> source2, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, Collection<V>>> mapFactory) {
        this(source2, keySelector, valueSelector, mapFactory, DefaultMultimapCollectionFactory.instance());
    }

    public OnSubscribeToMultimap(Observable<T> source2, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, Collection<V>>> mapFactory, Func1<? super K, ? extends Collection<V>> collectionFactory) {
        this.source = source2;
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.mapFactory = mapFactory == null ? this : mapFactory;
        this.collectionFactory = collectionFactory;
    }

    @Override
    public Map<K, Collection<V>> call() {
        return new HashMap();
    }

    @Override
    public void call(Subscriber<? super Map<K, Collection<V>>> subscriber) {
        Map<K, Collection<V>> map;
        try {
            map = this.mapFactory.call();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            subscriber.onError(ex);
            return;
        }
        new ToMultimapSubscriber<T, K, V>(subscriber, map, this.keySelector, this.valueSelector, this.collectionFactory).subscribeTo(this.source);
    }

    private static final class DefaultMultimapCollectionFactory<K, V>
    implements Func1<K, Collection<V>> {
        private static final DefaultMultimapCollectionFactory<Object, Object> INSTANCE = new DefaultMultimapCollectionFactory();

        private DefaultMultimapCollectionFactory() {
        }

        static <K, V> DefaultMultimapCollectionFactory<K, V> instance() {
            return INSTANCE;
        }

        @Override
        public Collection<V> call(K t1) {
            return new ArrayList();
        }
    }

    private static final class ToMultimapSubscriber<T, K, V>
    extends DeferredScalarSubscriberSafe<T, Map<K, Collection<V>>> {
        private final Func1<? super T, ? extends K> keySelector;
        private final Func1<? super T, ? extends V> valueSelector;
        private final Func1<? super K, ? extends Collection<V>> collectionFactory;

        ToMultimapSubscriber(Subscriber<? super Map<K, Collection<V>>> subscriber, Map<K, Collection<V>> map, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func1<? super K, ? extends Collection<V>> collectionFactory) {
            super(subscriber);
            this.value = map;
            this.hasValue = true;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.collectionFactory = collectionFactory;
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            try {
                K key = this.keySelector.call(t);
                V v = this.valueSelector.call(t);
                Collection<V> collection = (Collection<V>)((Map)this.value).get(key);
                if (collection == null) {
                    collection = this.collectionFactory.call(key);
                    ((Map)this.value).put(key, collection);
                }
                collection.add(v);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(ex);
            }
        }
    }
}

