/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import rx.Single;
import rx.SingleSubscriber;
import rx.exceptions.Exceptions;
import rx.subscriptions.Subscriptions;

public final class SingleFromFuture<T>
implements Single.OnSubscribe<T> {
    final Future<? extends T> future;
    final long timeout;
    final TimeUnit unit;

    public SingleFromFuture(Future<? extends T> future, long timeout2, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout2;
        this.unit = unit;
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        T v;
        Future<T> f = this.future;
        t.add(Subscriptions.from(f));
        try {
            v = this.timeout == 0L ? f.get() : f.get(this.timeout, this.unit);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            t.onError(ex);
            return;
        }
        t.onSuccess(v);
    }
}

