/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.NoSuchElementException;
import rx.Observable;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscriber;
import rx.plugins.RxJavaHooks;

public final class SingleFromObservable<T>
implements Single.OnSubscribe<T> {
    final Observable.OnSubscribe<T> source;

    public SingleFromObservable(Observable.OnSubscribe<T> source2) {
        this.source = source2;
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        WrapSingleIntoSubscriber<? super T> parent = new WrapSingleIntoSubscriber<T>(t);
        t.add(parent);
        this.source.call(parent);
    }

    static final class WrapSingleIntoSubscriber<T>
    extends Subscriber<T> {
        final SingleSubscriber<? super T> actual;
        T value;
        int state;
        static final int STATE_EMPTY = 0;
        static final int STATE_HAS_VALUE = 1;
        static final int STATE_DONE = 2;

        WrapSingleIntoSubscriber(SingleSubscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void onNext(T t) {
            int s2 = this.state;
            if (s2 == 0) {
                this.state = 1;
                this.value = t;
            } else if (s2 == 1) {
                this.state = 2;
                this.actual.onError(new IndexOutOfBoundsException("The upstream produced more than one value"));
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.state == 2) {
                RxJavaHooks.onError(e);
            } else {
                this.value = null;
                this.actual.onError(e);
            }
        }

        @Override
        public void onCompleted() {
            int s2 = this.state;
            if (s2 == 0) {
                this.actual.onError(new NoSuchElementException());
            } else if (s2 == 1) {
                this.state = 2;
                T v = this.value;
                this.value = null;
                this.actual.onSuccess(v);
            }
        }
    }
}

