/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.internal.operators.SingleFromObservable;
import rx.internal.producers.SingleProducer;
import rx.plugins.RxJavaHooks;

public final class SingleLiftObservableOperator<T, R>
implements Single.OnSubscribe<R> {
    final Single.OnSubscribe<T> source;
    final Observable.Operator<? extends R, ? super T> lift;

    public SingleLiftObservableOperator(Single.OnSubscribe<T> source2, Observable.Operator<? extends R, ? super T> lift) {
        this.source = source2;
        this.lift = lift;
    }

    @Override
    public void call(SingleSubscriber<? super R> t) {
        SingleFromObservable.WrapSingleIntoSubscriber<? super R> outputAsSubscriber = new SingleFromObservable.WrapSingleIntoSubscriber<R>(t);
        t.add(outputAsSubscriber);
        try {
            Subscriber inputAsSubscriber = (Subscriber)RxJavaHooks.onSingleLift(this.lift).call(outputAsSubscriber);
            SingleSubscriber<T> input = SingleLiftObservableOperator.wrap(inputAsSubscriber);
            inputAsSubscriber.onStart();
            this.source.call(input);
        }
        catch (Throwable ex) {
            Exceptions.throwOrReport(ex, t);
        }
    }

    public static <T> SingleSubscriber<T> wrap(Subscriber<T> subscriber) {
        WrapSubscriberIntoSingle<T> parent = new WrapSubscriberIntoSingle<T>(subscriber);
        subscriber.add(parent);
        return parent;
    }

    static final class WrapSubscriberIntoSingle<T>
    extends SingleSubscriber<T> {
        final Subscriber<? super T> actual;

        WrapSubscriberIntoSingle(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void onSuccess(T value) {
            this.actual.setProducer(new SingleProducer<T>(this.actual, value));
        }

        @Override
        public void onError(Throwable error) {
            this.actual.onError(error);
        }
    }
}

