/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk;

import com.fifa.connectid.sdk.CacheCleanJob;
import com.fifa.connectid.sdk.CancellationToken;
import com.fifa.connectid.sdk.PersonDetailsCache;
import com.fifa.connectid.sdk.PersonDetailsCacheCleanJobSettings;
import com.fifa.connectservicebus.sdk.logging.Logger;
import org.joda.time.Duration;

public class PersonDetailsCacheCleanJob
implements CacheCleanJob {
    private final PersonDetailsCache cache;
    private final PersonDetailsCacheCleanJobSettings settings;
    private final Logger logger;

    public PersonDetailsCacheCleanJob(PersonDetailsCache cache, PersonDetailsCacheCleanJobSettings settings, Logger logger) {
        if (cache == null) {
            throw new IllegalArgumentException("cache parameter cannot be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings parameter cannot be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("logger parameter cannot be null");
        }
        this.settings = settings;
        this.cache = cache;
        this.logger = logger;
    }

    @Override
    public void run(CancellationToken token) {
        new Thread(() -> this.runInternal(token)).start();
    }

    private void runInternal(CancellationToken token) {
        while (!token.getIsCancellationRequested()) {
            Duration deleteOlderThan = this.settings.getDeleteOlderThan();
            this.logger.debug("Deleting older than " + deleteOlderThan, new Object[0]);
            this.cache.deleteOlderThan(deleteOlderThan);
            try {
                Thread.sleep(this.settings.getInterval().getMillis());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

