/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk;

import com.fifa.connectid.sdk.BackgroundListener;
import com.fifa.connectid.sdk.CacheCleanJob;
import com.fifa.connectid.sdk.DefaultPersonDetailsReceivedHandler;
import com.fifa.connectid.sdk.DefaultPersonDetailsRequestReceivedHandler;
import com.fifa.connectid.sdk.DuplicatesOfRegisteredPerson;
import com.fifa.connectid.sdk.HashedPersonTypeHashingProcessorImpl;
import com.fifa.connectid.sdk.PersonDetails;
import com.fifa.connectid.sdk.PersonDetailsCache;
import com.fifa.connectid.sdk.PersonDetailsMemoryCache;
import com.fifa.connectid.sdk.PersonDetailsMessageExchanger;
import com.fifa.connectid.sdk.PersonDetailsProvider;
import com.fifa.connectid.sdk.PersonDuplicateWithDetails;
import com.fifa.connectid.sdk.RegistrationFacadeSettings;
import com.fifa.connectid.sdk.RegistrationResult;
import com.fifa.connectid.sdk.UpdateResult;
import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.ActorResolver;
import com.fifa.connectid.sdk.core.ConnectIdEnvironment;
import com.fifa.connectid.sdk.core.FifaConnectIdClient;
import com.fifa.connectid.sdk.core.FifaConnectIdClientImpl;
import com.fifa.connectid.sdk.core.FifaConnectIdException;
import com.fifa.connectid.sdk.core.FifaDuplicateOfRegisteredPersonFoundException;
import com.fifa.connectid.sdk.core.FifaDuplicatedPersonFoundException;
import com.fifa.connectid.sdk.core.HashedPersonProcessor;
import com.fifa.connectid.sdk.core.SimpleActorResolver;
import com.fifa.connectid.sdk.core.UnauthorizedException;
import com.fifa.connectid.sdk.core.api.models.GetActingOrganisationsResponseType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesOfRegisteredPersonResponseType;
import com.fifa.connectid.sdk.core.api.models.PersonDuplicateType;
import com.fifa.connectid.sdk.core.api.models.PersonType;
import com.fifa.connectid.sdk.core.api.models.RegistrationType;
import com.fifa.connectid.sdk.core.enhancements.ObjectFormatter;
import com.fifa.connectid.sdk.core.exceptions.MemberAssociationDoesNotRespondException;
import com.fifa.connectid.sdk.core.exceptions.PersonDetailsNotReceivedException;
import com.fifa.connectid.sdk.core.exceptions.PlayerRegistrationLevelRestrictionException;
import com.fifa.connectid.sdk.core.xmlparser.models.PersonData;
import com.fifa.connectid.sdk.core.xmlparser.models.PersonName;
import com.fifa.connectid.sdk.messageHandlers.MessageHandler;
import com.fifa.connectid.sdk.util.CorrelationId;
import com.fifa.connectservicebus.sdk.AuthenticationException;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusClient;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusClientImpl;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusException;
import com.fifa.connectservicebus.sdk.ProxySettings;
import com.fifa.connectservicebus.sdk.authentication.ClientCredentials;
import com.fifa.connectservicebus.sdk.encryption.PrivateKeyStorage;
import com.fifa.connectservicebus.sdk.logging.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.joda.time.LocalDate;

public class RegistrationFacade {
    private final PersonDetailsCache personDetailsCache;
    private final FifaConnectIdClient connectIdClient;
    private final FifaConnectServiceBusClient serviceBusClient;
    private final Logger logger;
    private final int pollingIntervalMilliseconds;
    private static final String FIFA_WORLD_ASSOCIATION_ID = "105C3ZB";
    private final PersonDetailsMessageExchanger personDetailsMessageExchanger;

    public RegistrationFacade(FifaConnectIdClient connectIdClient, FifaConnectServiceBusClient serviceBusClient, RegistrationFacadeSettings settings, Logger logger, boolean useEncryption) {
        if (logger == null) {
            throw new IllegalArgumentException("logger parameter cannot be null");
        }
        this.connectIdClient = connectIdClient;
        this.serviceBusClient = serviceBusClient;
        this.logger = logger;
        this.serviceBusClient.setUseEncryption(useEncryption);
        this.personDetailsCache = settings != null && settings.personDetailsCache != null ? settings.personDetailsCache : new PersonDetailsMemoryCache(10L, TimeUnit.MINUTES);
        this.pollingIntervalMilliseconds = settings != null && settings.pollingIntervalMilliseconds > 0 ? settings.pollingIntervalMilliseconds : 50;
        this.personDetailsMessageExchanger = new PersonDetailsMessageExchanger(serviceBusClient, logger);
    }

    public RegistrationFacade(ConnectIdEnvironment connectIdEnvironment, ClientCredentials clientCredentials, PrivateKeyStorage privateKeyStorage, RegistrationFacadeSettings settings, Logger logger, boolean useEncryption) {
        this(new FifaConnectIdClientImpl(connectIdEnvironment, clientCredentials, logger, RegistrationFacade.getActorResolver(settings), RegistrationFacade.getProxySettings(settings), RegistrationFacade.getExecutorService(settings), RegistrationFacade.getHashedPersonProcessor(settings)), (FifaConnectServiceBusClient)new FifaConnectServiceBusClientImpl(connectIdEnvironment.ServiceBusEnvironment, clientCredentials, privateKeyStorage, logger, RegistrationFacade.getProxySettings(settings), RegistrationFacade.getExecutorService(settings)), settings, logger, useEncryption);
    }

    public RegistrationFacade(ConnectIdEnvironment connectIdEnvironment, ClientCredentials clientCredentials, PrivateKeyStorage privateKeyStorage, RegistrationFacadeSettings settings, Logger logger) {
        this(connectIdEnvironment, clientCredentials, privateKeyStorage, settings, logger, true);
    }

    public RegistrationFacade(ConnectIdEnvironment connectIdEnvironment, ClientCredentials clientCredentials, PrivateKeyStorage privateKeyStorage, Logger logger) {
        this(connectIdEnvironment, clientCredentials, privateKeyStorage, null, logger, true);
    }

    public FifaConnectIdClient getConnectIdClient() {
        return this.connectIdClient;
    }

    public FifaConnectServiceBusClient getServiceBusClient() {
        return this.serviceBusClient;
    }

    public BackgroundListener configureListener(PersonDetailsProvider provider) {
        return this.configureListener(provider, new ArrayList<MessageHandler>());
    }

    public BackgroundListener configureListener(PersonDetailsProvider provider, Collection<MessageHandler> messageHandlers) {
        return this.configureListener(provider, messageHandlers, null);
    }

    public BackgroundListener configureListener(PersonDetailsProvider provider, Collection<MessageHandler> messageHandlers, CacheCleanJob cleanJob) {
        BackgroundListener listener = new BackgroundListener(this.serviceBusClient, cleanJob, this.logger, messageHandlers);
        listener.personDetailsReceivedEvent.addHandler(new DefaultPersonDetailsReceivedHandler(this.personDetailsCache));
        listener.personDetailsRequestReceivedEvent.addHandler(new DefaultPersonDetailsRequestReceivedHandler(this.serviceBusClient, provider));
        return listener;
    }

    public HashMap<String, PersonDuplicateWithDetails> sendRequestsForDetails(List<PersonDuplicateType> duplicates) throws FifaConnectServiceBusException {
        HashMap<String, PersonDuplicateWithDetails> correlationIdsAndDuplicates = new HashMap<String, PersonDuplicateWithDetails>();
        for (PersonDuplicateType duplicate : duplicates) {
            this.logger.debug("Handling duplicate: " + ObjectFormatter.toString(duplicate), new Object[0]);
            RegistrationType registration = duplicate.primaryDataProviderRegistrationType();
            String correlationId = CorrelationId.create();
            String recipient = null;
            try {
                PersonDuplicateWithDetails duplicateWithDetails;
                if (registration == null || registration.organisationFIFAId() == null) {
                    this.logger.debug(String.format("No organisation ID was found for person with ID %s. Skipping.", duplicate.personFifaId()), new Object[0]);
                    correlationIdsAndDuplicates.put(correlationId, PersonDuplicateWithDetails.Fail(duplicate, null, null, new ValidationException(String.format("No organisation found in person registrations for person %s", duplicate.personFifaId()))));
                    continue;
                }
                recipient = registration.systemId() != null && !registration.systemId().isEmpty() ? registration.systemId() : registration.organisationFIFAId();
                try {
                    this.personDetailsMessageExchanger.sendRequestForPersonDetails(duplicate.personFifaId(), recipient, correlationId);
                    duplicateWithDetails = PersonDuplicateWithDetails.Success(duplicate, registration.organisationFIFAId(), registration.systemId());
                }
                catch (FifaConnectServiceBusException ex) {
                    this.logger.error((Exception)((Object)ex), "Error occurred when sending request for details of '%s' to organisation '%s'", new Object[]{duplicate.personFifaId(), recipient});
                    duplicateWithDetails = PersonDuplicateWithDetails.Fail(duplicate, registration.organisationFIFAId(), registration.systemId(), (Exception)((Object)ex));
                }
                correlationIdsAndDuplicates.put(correlationId, duplicateWithDetails);
            }
            catch (Exception ex) {
                this.logger.error(ex, "Unexpected error occurred when trying to send request for details of '%s' to organisation: %s.", new Object[]{duplicate.personFifaId(), recipient});
                correlationIdsAndDuplicates.put(correlationId, PersonDuplicateWithDetails.Fail(duplicate, registration != null ? registration.organisationFIFAId() : null, registration != null ? registration.systemId() : null, ex));
            }
        }
        return correlationIdsAndDuplicates;
    }

    public HashMap<String, PersonDuplicateWithDetails> sendRequestsForDetailsAndWaitForThem(List<PersonDuplicateType> duplicates, long timeoutMilliseconds) throws FifaConnectServiceBusException {
        HashMap<String, PersonDuplicateWithDetails> idsAndDetails = new HashMap<String, PersonDuplicateWithDetails>(this.sendRequestsForDetails(duplicates));
        HashSet<String> stillExpectedResponses = new HashSet<String>();
        for (Map.Entry<String, PersonDuplicateWithDetails> entry : idsAndDetails.entrySet()) {
            if (!entry.getValue().shouldWaitForResponse().booleanValue()) continue;
            stillExpectedResponses.add(entry.getKey());
        }
        long endTime = System.currentTimeMillis() + timeoutMilliseconds;
        do {
            if (System.currentTimeMillis() > endTime) {
                StringBuilder notReceivedBuilder = new StringBuilder();
                for (String correlationId : stillExpectedResponses) {
                    PersonDuplicateWithDetails personDuplicateWithDetails = idsAndDetails.get(correlationId);
                    notReceivedBuilder.append(String.format("Correlation %s for person '%s' from organisation '%s', ", correlationId, personDuplicateWithDetails.getDuplicate(), personDuplicateWithDetails.getRequestRecipientOrganisationId()));
                }
                this.logger.debug(String.format("Timeout (%d ms) reached but %d/%d were not received: %s", timeoutMilliseconds, stillExpectedResponses.size(), idsAndDetails.size(), notReceivedBuilder.toString()), new Object[0]);
                break;
            }
            try {
                Thread.sleep(this.pollingIntervalMilliseconds);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ArrayList<String> receivedResponses = new ArrayList<String>();
            for (String correlationId : stillExpectedResponses) {
                PersonDetails response = this.personDetailsCache.getByCorrelationId(correlationId);
                if (response == null) continue;
                idsAndDetails.get(correlationId).setPersonDetails(response);
                receivedResponses.add(correlationId);
            }
            for (String correlationId : receivedResponses) {
                stillExpectedResponses.remove(correlationId);
            }
        } while (!stillExpectedResponses.isEmpty());
        return idsAndDetails;
    }

    public String forceRegisterPerson(PersonData personData) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        return this.forceRegisterPerson(personData, null);
    }

    public String forceRegisterPerson(PersonData personData, String personLocalId) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        return this.connectIdClient.forceRegisterPerson(personData, personLocalId);
    }

    public RegistrationResult registerPersonAndWaitForDetailsInCaseOfDuplicates(PersonData personData, long timeoutMilliseconds) throws FifaConnectIdException, FifaConnectServiceBusException, ValidationException {
        return this.registerPersonAndWaitForDetailsInCaseOfDuplicates(personData, timeoutMilliseconds, null);
    }

    public RegistrationResult registerPersonAndWaitForDetailsInCaseOfDuplicates(PersonData personData, long timeoutMilliseconds, String personLocalId) throws FifaConnectIdException, FifaConnectServiceBusException, ValidationException {
        try {
            String uniqueFifaId = this.connectIdClient.registerPerson(personData, personLocalId);
            return RegistrationResult.success(uniqueFifaId);
        }
        catch (FifaDuplicatedPersonFoundException ex) {
            List<PersonDuplicateType> duplicates = ex.getGetDuplicatesResponse().duplicates();
            HashMap<String, PersonDuplicateWithDetails> personDuplicateWithDetails = this.sendRequestsForDetailsAndWaitForThem(duplicates, timeoutMilliseconds);
            return RegistrationResult.duplicatesFound(personDuplicateWithDetails.values());
        }
    }

    @Deprecated
    public Collection<PersonDuplicateWithDetails> getDuplicatesAndWaitForDetailsInCaseOfDuplicates(PersonData personData, long timeoutMilliseconds) throws FifaConnectIdException, FifaConnectServiceBusException, ValidationException {
        return this.getDuplicates(personData, timeoutMilliseconds, new ArrayList<String>());
    }

    @Deprecated
    public Collection<PersonDuplicateWithDetails> getDuplicatesAndWaitForDetailsInCaseOfDuplicates(PersonData personData, long timeoutMilliseconds, List<String> organisationsIds) throws FifaConnectIdException, FifaConnectServiceBusException, ValidationException {
        return this.getDuplicates(personData, timeoutMilliseconds, organisationsIds);
    }

    public Collection<PersonDuplicateWithDetails> getDuplicates(PersonData personData, long timeoutMilliseconds) throws FifaConnectIdException, FifaConnectServiceBusException, ValidationException {
        return this.getDuplicates(personData, timeoutMilliseconds, new ArrayList<String>());
    }

    public Collection<PersonDuplicateWithDetails> getDuplicates(PersonData personData, long timeoutMilliseconds, List<String> organisationsIds) throws FifaConnectIdException, FifaConnectServiceBusException, ValidationException {
        List<PersonDuplicateType> duplicates = this.connectIdClient.getPersonDuplicates(personData, organisationsIds);
        HashMap<String, PersonDuplicateWithDetails> personDuplicateWithDetails = this.sendRequestsForDetailsAndWaitForThem(duplicates, timeoutMilliseconds);
        return personDuplicateWithDetails.values();
    }

    public DuplicatesOfRegisteredPerson getDuplicatesExceptTrustedKnownDuplicates(String personFifaId, List<String> trustedOrganisationsIds, long timeoutInMilliseconds) throws FifaConnectIdException, FifaConnectServiceBusException, ValidationException {
        GetDuplicatesOfRegisteredPersonResponseType duplicatesResponse = this.connectIdClient.getPersonDuplicatesExceptTrustedKnownDuplicates(personFifaId, trustedOrganisationsIds);
        return this.getDuplicatesOfRegisteredPerson(duplicatesResponse, timeoutInMilliseconds);
    }

    public PersonType forceUpdatePerson(String personId, List<PersonName> names, LocalDate dateOfBirth) throws AuthenticationException, FifaConnectIdException, UnauthorizedException, ValidationException {
        return this.forceUpdatePerson(personId, names, dateOfBirth, null);
    }

    public PersonType forceUpdatePerson(String personId, List<PersonName> names, LocalDate dateOfBirth, String gender) throws AuthenticationException, FifaConnectIdException, UnauthorizedException, ValidationException {
        return this.connectIdClient.updatePerson(personId, names, dateOfBirth, gender, true);
    }

    public UpdateResult updatePersonAndWaitForDetailsInCaseOfDuplicates(String personId, List<PersonName> names, LocalDate dateOfBirth, long timeoutMilliseconds) throws FifaConnectIdException, FifaConnectServiceBusException, ValidationException {
        return this.updatePersonAndWaitForDetailsInCaseOfDuplicates(personId, names, dateOfBirth, null, timeoutMilliseconds);
    }

    public UpdateResult updatePersonAndWaitForDetailsInCaseOfDuplicates(String personId, List<PersonName> names, LocalDate dateOfBirth, String gender, long timeoutMilliseconds) throws FifaConnectIdException, FifaConnectServiceBusException, ValidationException {
        try {
            PersonType personType = this.connectIdClient.updatePerson(personId, names, dateOfBirth, gender, false);
            return UpdateResult.success(personType);
        }
        catch (FifaDuplicateOfRegisteredPersonFoundException ex) {
            return UpdateResult.duplicatesFound(this.getDuplicatesOfRegisteredPerson(ex.getGetDuplicatesResponse(), timeoutMilliseconds));
        }
    }

    private DuplicatesOfRegisteredPerson getDuplicatesOfRegisteredPerson(GetDuplicatesOfRegisteredPersonResponseType response, long timeoutMilliseconds) throws FifaConnectServiceBusException {
        List<PersonDuplicateType> duplicates = response.duplicates();
        HashMap<String, PersonDuplicateWithDetails> personDuplicateWithDetails = this.sendRequestsForDetailsAndWaitForThem(duplicates, timeoutMilliseconds);
        return new DuplicatesOfRegisteredPerson(response.requestedPersonRegistrationContext(), personDuplicateWithDetails.values());
    }

    public String sendRequestForDetailsAndWaitForThem(String uniqueFifaId, long timeoutMilliseconds) throws IOException, IllegalStateException, UnauthorizedException, AuthenticationException, PlayerRegistrationLevelRestrictionException, FifaConnectServiceBusException, MemberAssociationDoesNotRespondException, PersonDetailsNotReceivedException, FifaConnectIdException, ValidationException {
        this.validateFifaAccessLevel();
        RegistrationType registration = this.connectIdClient.getPrimaryDataProviderRegistrationType(uniqueFifaId);
        String recipientId = this.extractRecipientFifaId(registration, uniqueFifaId);
        return this.sendRequestForDetailsAndWaitForThemCore(uniqueFifaId, timeoutMilliseconds, recipientId);
    }

    public String sendRequestForDetailsAndWaitForThem(String uniqueFifaId, long timeoutMilliseconds, String recipientId) throws IOException, UnauthorizedException, AuthenticationException, PlayerRegistrationLevelRestrictionException, FifaConnectServiceBusException, MemberAssociationDoesNotRespondException, PersonDetailsNotReceivedException, FifaConnectIdException {
        this.validateFifaAccessLevel();
        return this.sendRequestForDetailsAndWaitForThemCore(uniqueFifaId, timeoutMilliseconds, recipientId);
    }

    private String sendRequestForDetailsAndWaitForThemCore(String uniqueFifaId, long timeoutMilliseconds, String recipientId) throws IOException, FifaConnectServiceBusException, MemberAssociationDoesNotRespondException, PersonDetailsNotReceivedException, FifaConnectIdException {
        String correlationId = this.sendRequestForPersonDetails(uniqueFifaId, recipientId);
        long endTime = System.currentTimeMillis() + timeoutMilliseconds;
        PersonDetails personDetails = null;
        while (System.currentTimeMillis() < endTime && personDetails == null) {
            try {
                Thread.sleep(this.pollingIntervalMilliseconds);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            personDetails = this.personDetailsCache.getByCorrelationId(correlationId);
        }
        if (personDetails == null) {
            MemberAssociationDoesNotRespondException exception = new MemberAssociationDoesNotRespondException(recipientId, timeoutMilliseconds);
            this.logger.error(exception.getMessage(), new Object[0]);
            throw exception;
        }
        if (personDetails.getXmlData() == null || personDetails.getXmlData().isEmpty()) {
            PersonDetailsNotReceivedException exception = new PersonDetailsNotReceivedException(uniqueFifaId, recipientId);
            this.logger.error(exception.getMessage(), new Object[0]);
            throw exception;
        }
        return personDetails.getXmlData();
    }

    private String sendRequestForPersonDetails(String uniqueFifaId, String recipient) throws FifaConnectServiceBusException {
        String correlationId = CorrelationId.create();
        this.personDetailsMessageExchanger.sendRequestForPersonDetails(uniqueFifaId, recipient, correlationId);
        return correlationId;
    }

    private String extractRecipientFifaId(RegistrationType registration, String uniqueFifaId) throws IllegalStateException {
        if (registration == null || registration.organisationFIFAId() == null) {
            String message = "Person with ID `" + uniqueFifaId + "` has no registrations defined. Unable to determine recipient organisation FIFA ID.";
            this.logger.error(message, new Object[0]);
            throw new IllegalStateException(message);
        }
        return registration.systemId() == null || registration.systemId().isEmpty() ? registration.organisationFIFAId() : registration.systemId();
    }

    private void validateFifaAccessLevel() throws UnauthorizedException, FifaConnectIdException, IOException {
        GetActingOrganisationsResponseType actingOrganisations = this.connectIdClient.getIdDirectoryClient().getActingOrganisations();
        if (!actingOrganisations.organisationsFIFAIds().contains(FIFA_WORLD_ASSOCIATION_ID)) {
            throw new UnauthorizedException("Operation cannot be executed without FIFA World Association level permissions.");
        }
    }

    private static ActorResolver getActorResolver(RegistrationFacadeSettings settings) {
        return settings != null && settings.actorResolver != null ? settings.actorResolver : SimpleActorResolver.empty();
    }

    private static ProxySettings getProxySettings(RegistrationFacadeSettings settings) {
        return settings != null && settings.proxySettings != null ? settings.proxySettings : ProxySettings.empty();
    }

    private static ExecutorService getExecutorService(RegistrationFacadeSettings settings) {
        return settings != null ? settings.executorService : null;
    }

    private static HashedPersonProcessor getHashedPersonProcessor(RegistrationFacadeSettings settings) {
        return settings != null && settings.hashedPersonProcessor != null ? settings.hashedPersonProcessor : new HashedPersonTypeHashingProcessorImpl();
    }
}

