/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core;

import com.fifa.connectid.sdk.HashedPersonTypeHashingProcessorImpl;
import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.ActorResolver;
import com.fifa.connectid.sdk.core.ConnectIdEnvironment;
import com.fifa.connectid.sdk.core.FifaConnectIdClient;
import com.fifa.connectid.sdk.core.FifaConnectIdException;
import com.fifa.connectid.sdk.core.FifaEntityDeletedException;
import com.fifa.connectid.sdk.core.FifaEntityNotFoundException;
import com.fifa.connectid.sdk.core.FifaPersonMergedException;
import com.fifa.connectid.sdk.core.HashedPersonProcessor;
import com.fifa.connectid.sdk.core.InvalidClientDataException;
import com.fifa.connectid.sdk.core.SimpleActorResolver;
import com.fifa.connectid.sdk.core.UnauthorizedException;
import com.fifa.connectid.sdk.core.api.models.AddRegistrationsRequestType;
import com.fifa.connectid.sdk.core.api.models.BulkDeactivateRegistrationsRequestType;
import com.fifa.connectid.sdk.core.api.models.BulkDeactivateRegistrationsResponseType;
import com.fifa.connectid.sdk.core.api.models.FacilityLocalType;
import com.fifa.connectid.sdk.core.api.models.FindFacilitiesRequestType;
import com.fifa.connectid.sdk.core.api.models.FindFacilitiesResponseType;
import com.fifa.connectid.sdk.core.api.models.FindOrganisationsRequestType;
import com.fifa.connectid.sdk.core.api.models.FindOrganisationsResponseType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesByFIFAIdRequestType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesOfRegisteredPersonResponseType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesRequestType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesResponseType;
import com.fifa.connectid.sdk.core.api.models.GetFacilityDuplicatesResponseType;
import com.fifa.connectid.sdk.core.api.models.GetOrganisationDuplicatesResponseType;
import com.fifa.connectid.sdk.core.api.models.HashedNameType;
import com.fifa.connectid.sdk.core.api.models.MemberAssociationResponseType;
import com.fifa.connectid.sdk.core.api.models.NationalAssociationsOnboardedRequestType;
import com.fifa.connectid.sdk.core.api.models.NationalAssociationsOnboardedResponseType;
import com.fifa.connectid.sdk.core.api.models.OrganisationLocalType;
import com.fifa.connectid.sdk.core.api.models.PersonDuplicateType;
import com.fifa.connectid.sdk.core.api.models.PersonType;
import com.fifa.connectid.sdk.core.api.models.RegisterPersonRequestType;
import com.fifa.connectid.sdk.core.api.models.RegisterResponseType;
import com.fifa.connectid.sdk.core.api.models.RegistrationType;
import com.fifa.connectid.sdk.core.api.models.UpdatePersonRequestType;
import com.fifa.connectid.sdk.core.api.models.UpdateRegistrationsRequestType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ContextTypeValidator;
import com.fifa.connectid.sdk.core.authentication.ConnectIdAuthenticationResourceBuilderImpl;
import com.fifa.connectid.sdk.core.hashing.HashingServiceClient;
import com.fifa.connectid.sdk.core.hashing.HashingServiceClientImpl;
import com.fifa.connectid.sdk.core.iddirectory.IdDirectoryServiceClient;
import com.fifa.connectid.sdk.core.iddirectory.IdDirectoryServiceClientImpl;
import com.fifa.connectid.sdk.core.xmlparser.models.PersonData;
import com.fifa.connectid.sdk.core.xmlparser.models.PersonName;
import com.fifa.connectservicebus.sdk.AuthenticationException;
import com.fifa.connectservicebus.sdk.HttpClientFactory;
import com.fifa.connectservicebus.sdk.OkHttpClientAdapter;
import com.fifa.connectservicebus.sdk.ProxySettings;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationInformation;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationResourceBuilder;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationService;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationServiceImpl;
import com.fifa.connectservicebus.sdk.authentication.ClientCredentials;
import com.fifa.connectservicebus.sdk.logging.Logger;
import com.microsoft.aad.msal4j.IHttpClient;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.joda.time.LocalDate;

public class FifaConnectIdClientImpl
implements FifaConnectIdClient {
    private final HashingServiceClient hashingServiceClient;
    private final IdDirectoryServiceClient idDirectoryServiceClient;
    private final Logger logger;
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(60L);

    public FifaConnectIdClientImpl(HashingServiceClient hashingServiceClient, IdDirectoryServiceClient idDirectoryServiceClient, Logger logger) {
        this.hashingServiceClient = hashingServiceClient;
        this.idDirectoryServiceClient = idDirectoryServiceClient;
        if (logger == null) {
            throw new IllegalArgumentException("logger parameter cannot be null");
        }
        this.logger = logger;
    }

    public FifaConnectIdClientImpl(ConnectIdEnvironment connectIdEnvironment, ClientCredentials clientCredentials, Logger logger, ActorResolver actorResolver, ProxySettings proxySettings, ExecutorService executorService, HashedPersonProcessor hashedPersonProcessor) {
        this(FifaConnectIdClientImpl.buildHashingService(connectIdEnvironment, clientCredentials, logger, proxySettings, executorService), FifaConnectIdClientImpl.buildIdDirectoryService(connectIdEnvironment, clientCredentials, logger, actorResolver, proxySettings, executorService, hashedPersonProcessor), logger);
    }

    public FifaConnectIdClientImpl(ConnectIdEnvironment connectIdEnvironment, ClientCredentials clientCredentials, Logger logger, ActorResolver actorResolver, ProxySettings proxySettings, ExecutorService executorService) {
        this(FifaConnectIdClientImpl.buildHashingService(connectIdEnvironment, clientCredentials, logger, proxySettings, executorService), FifaConnectIdClientImpl.buildIdDirectoryService(connectIdEnvironment, clientCredentials, logger, actorResolver, proxySettings, executorService, new HashedPersonTypeHashingProcessorImpl()), logger);
    }

    public FifaConnectIdClientImpl(ConnectIdEnvironment connectIdEnvironment, ClientCredentials clientCredentials, Logger logger, ActorResolver actorResolver, ProxySettings proxySettings) {
        this(connectIdEnvironment, clientCredentials, logger, actorResolver, proxySettings, null);
    }

    public FifaConnectIdClientImpl(ConnectIdEnvironment connectIdEnvironment, ClientCredentials clientCredentials, Logger logger, ActorResolver actorResolver) {
        this(connectIdEnvironment, clientCredentials, logger, actorResolver, ProxySettings.empty());
    }

    public FifaConnectIdClientImpl(ConnectIdEnvironment connectIdEnvironment, ClientCredentials clientCredentials, Logger logger) {
        this(connectIdEnvironment, clientCredentials, logger, SimpleActorResolver.empty());
    }

    private static IdDirectoryServiceClient buildIdDirectoryService(ConnectIdEnvironment connectIdEnvironment, ClientCredentials clientCredentials, Logger logger, ActorResolver actorResolver, ProxySettings proxySettings, ExecutorService executorService, HashedPersonProcessor hashedPersonProcessor) {
        AuthenticationInformation authenticationInformation = new AuthenticationInformation((AuthenticationResourceBuilder)new ConnectIdAuthenticationResourceBuilderImpl(), clientCredentials, URI.create(connectIdEnvironment.IdDirectoryUrl), connectIdEnvironment.Tenant);
        OkHttpClientAdapter adapter = new OkHttpClientAdapter(HttpClientFactory.create((ProxySettings)proxySettings, (Duration)REQUEST_TIMEOUT));
        return IdDirectoryServiceClientImpl.CreateSyncClient(connectIdEnvironment, (AuthenticationService)new AuthenticationServiceImpl(authenticationInformation, (IHttpClient)adapter, executorService), logger, actorResolver, proxySettings, hashedPersonProcessor);
    }

    private static HashingServiceClientImpl buildHashingService(ConnectIdEnvironment connectIdEnvironment, ClientCredentials clientCredentials, Logger logger, ProxySettings proxySettings, ExecutorService executorService) {
        AuthenticationInformation authenticationInformation = new AuthenticationInformation((AuthenticationResourceBuilder)new ConnectIdAuthenticationResourceBuilderImpl(), clientCredentials, URI.create(connectIdEnvironment.HashingServiceUrl), connectIdEnvironment.Tenant);
        OkHttpClientAdapter adapter = new OkHttpClientAdapter(HttpClientFactory.create((ProxySettings)proxySettings, (Duration)REQUEST_TIMEOUT));
        return HashingServiceClientImpl.CreateSyncClient(connectIdEnvironment, (AuthenticationService)new AuthenticationServiceImpl(authenticationInformation, (IHttpClient)adapter, executorService), logger, proxySettings);
    }

    @Override
    public PersonType getPerson(String personFifaId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.getPerson(personFifaId);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to get person %s", new Object[]{personFifaId});
            throw ex;
        }
    }

    @Override
    public RegistrationType getPrimaryDataProviderRegistrationType(String personFifaId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.getPrimaryDataProviderRegistrationType(personFifaId);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to get primary data provider for %s", new Object[]{personFifaId});
            throw ex;
        }
    }

    @Override
    public List<PersonDuplicateType> getPersonDuplicates(PersonData personData) throws FifaConnectIdException, AuthenticationException, ValidationException {
        return this.getPersonDuplicates(personData, new ArrayList<String>());
    }

    @Override
    public List<PersonDuplicateType> getPersonDuplicates(PersonData personData, List<String> organisationsIds) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            ContextTypeValidator.validate(personData, "personData");
            List<HashedNameType> hashes = this.hashingServiceClient.computeHashes(personData.getNames(), true);
            GetDuplicatesRequestType requestType = new GetDuplicatesRequestType();
            requestType.withNameHashes(hashes);
            requestType.withPerson(personData.getPerson());
            ArrayList<String> organizationsToLookWithin = new ArrayList<String>();
            if (organisationsIds != null) {
                organizationsToLookWithin.addAll(organisationsIds);
            }
            requestType.withOrganisationsFIFAIds(organizationsToLookWithin);
            GetDuplicatesResponseType duplicatesResponse = this.idDirectoryServiceClient.getPersonDuplicates(requestType);
            return duplicatesResponse.duplicates();
        }
        catch (Exception ex) {
            String personDataString = personData == null ? "" : personData.toJsonString();
            this.logger.error(ex, "Failed to get duplicates for %s", new Object[]{personDataString});
            throw ex;
        }
    }

    @Override
    public GetDuplicatesOfRegisteredPersonResponseType getPersonDuplicatesExceptTrustedKnownDuplicates(String personFifaId, List<String> trustedOrganisationsIds) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            GetDuplicatesByFIFAIdRequestType request = new GetDuplicatesByFIFAIdRequestType();
            request.withPersonFIFAId(personFifaId);
            request.withTrustedOrganisationsFIFAIds(trustedOrganisationsIds);
            return this.idDirectoryServiceClient.getPersonDuplicates(request);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to get duplicates except trusted known duplicates of %s", new Object[]{personFifaId});
            throw ex;
        }
    }

    @Override
    public List<OrganisationLocalType> getOrganisationDuplicates(OrganisationLocalType organisation) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            GetOrganisationDuplicatesResponseType duplicatesResponse = this.idDirectoryServiceClient.getOrganisationDuplicates(organisation);
            return duplicatesResponse.duplicates();
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to get organisation duplicates of %s", new Object[]{organisation});
            throw ex;
        }
    }

    @Override
    public List<FacilityLocalType> getFacilityDuplicates(FacilityLocalType facility) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            GetFacilityDuplicatesResponseType duplicatesResponse = this.idDirectoryServiceClient.getFacilityDuplicates(facility);
            return duplicatesResponse.duplicates();
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to get duplicates for facility %s", new Object[]{facility});
            throw ex;
        }
    }

    @Override
    public String registerPerson(PersonData personData) throws FifaConnectIdException, AuthenticationException, ValidationException {
        return this.registerPerson(personData, null);
    }

    @Override
    public String registerPerson(PersonData personData, String peronLocalId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        return this.registerPerson(personData, false, peronLocalId);
    }

    @Override
    public String forceRegisterPerson(PersonData personData) throws FifaConnectIdException, AuthenticationException, ValidationException {
        return this.forceRegisterPerson(personData, null);
    }

    @Override
    public String forceRegisterPerson(PersonData personData, String personLocalId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        return this.registerPerson(personData, true, personLocalId);
    }

    @Override
    public PersonType updatePerson(String personId, List<PersonName> names, LocalDate dateOfBirth, boolean force) throws AuthenticationException, FifaConnectIdException, ValidationException {
        return this.updatePerson(personId, names, dateOfBirth, null, force);
    }

    @Override
    public PersonType updatePerson(String personId, List<PersonName> names, LocalDate dateOfBirth, String gender, boolean force) throws AuthenticationException, FifaConnectIdException, ValidationException {
        if ((names == null || names.isEmpty()) && dateOfBirth == null && gender == null) {
            throw new IllegalArgumentException("At least one of parameters 'names', 'dateOfBirth' or 'gender' is required.");
        }
        try {
            UpdatePersonRequestType request = new UpdatePersonRequestType();
            if (names != null) {
                List<HashedNameType> hashes = this.hashingServiceClient.computeHashes(names, false);
                request.withNameHashes(hashes);
            }
            request.withPersonId(personId);
            request.withDateOfBirth(dateOfBirth);
            request.withGender(gender);
            return this.idDirectoryServiceClient.updatePerson(request, force);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to update person %s", new Object[]{personId});
            throw ex;
        }
    }

    @Override
    public PersonType addRegistrations(AddRegistrationsRequestType request, Boolean force) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.addRegistrations(request, force);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to %s registrations: %s", new Object[]{FifaConnectIdClientImpl.forceToString(force, "add"), request});
            throw ex;
        }
    }

    @Override
    public PersonType updateRegistrations(UpdateRegistrationsRequestType request, Boolean force) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.updateRegistrations(request, force);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to %s registrations: %s", new Object[]{FifaConnectIdClientImpl.forceToString(force, "update"), request});
            throw ex;
        }
    }

    @Override
    public OrganisationLocalType getOrganisation(String organisationFifaId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.getOrganisation(organisationFifaId);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to get organisation %s", new Object[]{organisationFifaId});
            throw ex;
        }
    }

    @Override
    public String registerOrganisation(OrganisationLocalType organisation, Boolean force) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            RegisterResponseType registerResponse = this.idDirectoryServiceClient.registerOrganisation(organisation, force);
            return registerResponse.uniqueFifaId();
        }
        catch (Exception ex) {
            String organisationName = organisation.internationalName();
            if (organisationName == null) {
                organisationName = organisation.internationalShortName();
            }
            this.logger.error(ex, "Failed to " + FifaConnectIdClientImpl.forceToString(force, "register") + " organisation %s", new Object[]{organisationName});
            throw ex;
        }
    }

    @Override
    public String registerOrganisation(OrganisationLocalType organisation) throws FifaConnectIdException, AuthenticationException, ValidationException {
        return this.registerOrganisation(organisation, false);
    }

    @Override
    public PersonType mergePersons(String primaryPersonId, String secondaryPersonId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.mergePersons(primaryPersonId, secondaryPersonId);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to merge persons %s (Primary) and %s (Secondary)", new Object[]{primaryPersonId, secondaryPersonId});
            throw ex;
        }
    }

    @Override
    public PersonType unmergePersons(String primaryPersonId, String secondaryPersonId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.unmergePersons(primaryPersonId, secondaryPersonId);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to unmerge persons %s (Primary) and %s (Secondary)", new Object[]{primaryPersonId, secondaryPersonId});
            throw ex;
        }
    }

    @Override
    public BulkDeactivateRegistrationsResponseType bulkDeactivateRegistrations(BulkDeactivateRegistrationsRequestType request) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.bulkDeactivateRegistrations(request);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to bulk deactivate registrations: %s", new Object[]{request});
            throw ex;
        }
    }

    @Override
    public OrganisationLocalType mergeOrganisations(String primaryOrganisationFifaId, String secondaryOrganisationFifaId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.mergeOrganisations(primaryOrganisationFifaId, secondaryOrganisationFifaId);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to merge organisations %s (Primary) and %s (Secondary)", new Object[]{primaryOrganisationFifaId, secondaryOrganisationFifaId});
            throw ex;
        }
    }

    @Override
    public OrganisationLocalType unmergeOrganisations(String primaryOrganisationFifaId, String secondaryOrganisationFifaId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.unmergeOrganisations(primaryOrganisationFifaId, secondaryOrganisationFifaId);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to unmerge organisations %s (Primary) and %s (Secondary)", new Object[]{primaryOrganisationFifaId, secondaryOrganisationFifaId});
            throw ex;
        }
    }

    @Override
    public OrganisationLocalType updateOrganisation(OrganisationLocalType organisation, Boolean force) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.updateOrganisation(organisation, force);
        }
        catch (IllegalArgumentException ex) {
            this.logger.error((Exception)ex, ex.getMessage(), new Object[0]);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to " + FifaConnectIdClientImpl.forceToString(force, "update") + " the organisation %s", new Object[]{organisation.organisationFIFAId()});
            throw ex;
        }
    }

    @Override
    public OrganisationLocalType updateOrganisation(OrganisationLocalType organisation) throws FifaConnectIdException, AuthenticationException, ValidationException {
        return this.updateOrganisation(organisation, false);
    }

    @Override
    public FacilityLocalType getFacility(String facilityFifaId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.getFacility(facilityFifaId);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to get facility %s", new Object[]{facilityFifaId});
            throw ex;
        }
    }

    @Override
    public String registerFacility(FacilityLocalType facility, Boolean force) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            RegisterResponseType registerResponse = this.idDirectoryServiceClient.registerFacility(facility, force);
            return registerResponse.uniqueFifaId();
        }
        catch (Exception ex) {
            String facilityName = facility.internationalName();
            if (facilityName == null) {
                facilityName = facility.internationalShortName();
            }
            this.logger.error(ex, "Failed to " + FifaConnectIdClientImpl.forceToString(force, "register") + " facility %s", new Object[]{facilityName});
            throw ex;
        }
    }

    @Override
    public String registerFacility(FacilityLocalType facility) throws FifaConnectIdException, AuthenticationException, ValidationException {
        return this.registerFacility(facility, false);
    }

    @Override
    public FacilityLocalType updateFacility(FacilityLocalType facility, Boolean force) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.updateFacility(facility, force);
        }
        catch (IllegalArgumentException ex) {
            this.logger.error((Exception)ex, ex.getMessage(), new Object[0]);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to " + FifaConnectIdClientImpl.forceToString(force, "update") + " the facility %s", new Object[]{facility.facilityFIFAId()});
            throw ex;
        }
    }

    @Override
    public FacilityLocalType updateFacility(FacilityLocalType facility) throws FifaConnectIdException, AuthenticationException, ValidationException {
        return this.updateFacility(facility, false);
    }

    @Override
    public FindOrganisationsResponseType findOrganisations(FindOrganisationsRequestType request) throws FifaConnectIdException, IOException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.findOrganisations(request);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to find organisations: %s", new Object[]{request});
            throw ex;
        }
    }

    @Override
    public FindFacilitiesResponseType findFacilities(FindFacilitiesRequestType request) throws FifaConnectIdException, IOException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.findFacilities(request);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to find facilities: %s", new Object[]{request});
            throw ex;
        }
    }

    @Override
    public NationalAssociationsOnboardedResponseType getAllNationalAssociationsOnboardedStatus() throws IOException, AuthenticationException, FifaConnectIdException {
        try {
            return this.idDirectoryServiceClient.GetAllNationalAssociationsOnboardedStatus();
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to verify National Associations onboarded status", new Object[0]);
            throw ex;
        }
    }

    @Override
    public NationalAssociationsOnboardedResponseType getNationalAssociationsOnboardedStatus(NationalAssociationsOnboardedRequestType request) throws IOException, AuthenticationException, FifaConnectIdException, ValidationException {
        try {
            return this.idDirectoryServiceClient.GetNationalAssociationsOnboardedStatus(request);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to verify if organisations [%s] are onboarded", new Object[]{String.join((CharSequence)",", request.nationalAssociationsFifaIds())});
            throw ex;
        }
    }

    @Override
    public MemberAssociationResponseType getMemberAssociationForFifaId(String organisationFifaId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            return this.idDirectoryServiceClient.getMemberAssociationForFifaId(organisationFifaId);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to get Member Associations for %s", new Object[]{organisationFifaId});
            throw ex;
        }
    }

    @Override
    public void registerAsDataHolderOfPerson(String personFifaId) throws ValidationException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaPersonMergedException, FifaEntityNotFoundException, FifaEntityDeletedException, FifaConnectIdException {
        try {
            this.idDirectoryServiceClient.registerAsDataHolderOfPerson(personFifaId);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to register as data holder of person %s", new Object[]{personFifaId});
            throw ex;
        }
    }

    @Override
    public List<String> getDataHoldersOfPerson(String personFifaId) throws ValidationException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaPersonMergedException, FifaEntityNotFoundException, FifaEntityDeletedException, FifaConnectIdException {
        try {
            return this.idDirectoryServiceClient.getDataHoldersOfPerson(personFifaId);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to get Data Holders of person %s", new Object[]{personFifaId});
            throw ex;
        }
    }

    @Override
    public List<String> getMergedSecondaryFifaIdsForPerson(String personFifaId) throws ValidationException, AuthenticationException, FifaConnectIdException {
        try {
            return this.idDirectoryServiceClient.getMergedSecondaryFifaIdsForPerson(personFifaId);
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to get merged secondary FIFA IDs for %s", new Object[]{personFifaId});
            throw ex;
        }
    }

    private static String forceToString(Boolean force, String operationName) {
        return force != false ? "force " + operationName : operationName;
    }

    @Override
    public HashingServiceClient getHashingClient() {
        return this.hashingServiceClient;
    }

    @Override
    public IdDirectoryServiceClient getIdDirectoryClient() {
        return this.idDirectoryServiceClient;
    }

    private String registerPerson(PersonData personData, boolean forceRegister, String personLocalId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        try {
            List<HashedNameType> hashes = this.hashingServiceClient.computeHashes(personData.getNames(), false);
            RegisterPersonRequestType requestType = new RegisterPersonRequestType();
            requestType.withNameHashes(hashes);
            requestType.withPerson(personData.getPerson());
            requestType.withLocalId(personLocalId);
            RegisterResponseType registerResponse = forceRegister ? this.idDirectoryServiceClient.forceRegisterPerson(requestType) : this.idDirectoryServiceClient.registerPerson(requestType);
            return registerResponse.uniqueFifaId();
        }
        catch (Exception ex) {
            this.logger.error(ex, "Failed to " + FifaConnectIdClientImpl.forceToString(forceRegister, "register") + " %s with local ID = %s", new Object[]{personData, personLocalId});
            throw ex;
        }
    }
}

