/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core;

import com.fifa.connectid.sdk.core.FifaConnectIdException;
import com.fifa.connectid.sdk.core.FifaEntityNotFoundException;
import com.fifa.connectid.sdk.core.InvalidClientDataException;
import com.fifa.connectid.sdk.core.TooManyRequestsException;
import com.fifa.connectid.sdk.core.enhancements.ObjectFormatter;
import com.fifa.connectid.sdk.core.errorhandling.BadRequestHandler;
import com.fifa.connectid.sdk.core.errorhandling.EntityDeletedExceptionHandler;
import com.fifa.connectid.sdk.core.errorhandling.EntityNotFoundExceptionHandler;
import com.fifa.connectid.sdk.core.errorhandling.ErrorResponseHandler;
import com.fifa.connectid.sdk.core.errorhandling.TooManyRequestsHandler;
import com.fifa.connectid.sdk.core.errorhandling.UnauthorizedRequestHandler;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import retrofit2.Response;

public class ServiceResponseUtils {
    private static final ErrorResponseHandler[] knownCommonErrorResponseHandlers = new ErrorResponseHandler[]{new BadRequestHandler(), new EntityNotFoundExceptionHandler(), new EntityDeletedExceptionHandler(), new UnauthorizedRequestHandler(), new TooManyRequestsHandler()};

    public static void handleResponse(ServiceResponse<Object> serviceResponse, int expectedStatusCode, ErrorResponseHandler ... additionalErrorResponseHandlers) throws InvalidClientDataException, FifaEntityNotFoundException, TooManyRequestsException, FifaConnectIdException {
        ErrorResponseHandler[] errorResponseHandlers;
        int statusCode = serviceResponse.response().code();
        if (statusCode == expectedStatusCode) {
            return;
        }
        for (ErrorResponseHandler errorResponseHandler : errorResponseHandlers = (ErrorResponseHandler[])ArrayUtils.addAll((Object[])knownCommonErrorResponseHandlers, (Object[])additionalErrorResponseHandlers)) {
            errorResponseHandler.Handle(serviceResponse);
        }
        String message = "Unexpected server response: " + statusCode + ". Details: " + ServiceResponseUtils.getUnexpectedResponseDetails(serviceResponse);
        throw new FifaConnectIdException(message, serviceResponse);
    }

    public static <T> T extractResult(ServiceResponse<Object> serviceResponse, Class<T> clazz, int expectedStatusCode, ErrorResponseHandler ... additionalErrorResponseHandlers) throws InvalidClientDataException, FifaEntityNotFoundException, TooManyRequestsException, FifaConnectIdException {
        ServiceResponseUtils.handleResponse(serviceResponse, expectedStatusCode, additionalErrorResponseHandlers);
        Object body = serviceResponse.body();
        try {
            return clazz.cast(body);
        }
        catch (ClassCastException ignored) {
            int statusCode = serviceResponse.response().code();
            String message = "Unexpected body content for valid server response: " + statusCode + ". Details: " + ServiceResponseUtils.getUnexpectedResponseDetails(serviceResponse);
            throw new FifaConnectIdException(message, serviceResponse);
        }
    }

    private static String getUnexpectedResponseDetails(ServiceResponse<Object> serviceResponse) {
        Object body = serviceResponse.body();
        if (body != null) {
            return ObjectFormatter.toJson(body);
        }
        Response response = serviceResponse.response();
        String details = "Message = " + response.message();
        try {
            return String.format("%s, Body = %s", details, response.errorBody().string());
        }
        catch (IOException e) {
            return details + ". Failed to get the error body: " + e.getMessage();
        }
    }
}

