/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.api.implementation;

import com.fifa.connectid.sdk.core.api.DataHolders;
import com.fifa.connectid.sdk.core.api.implementation.FIFAConnectIDIDDirectoryV6Impl;
import com.fifa.connectid.sdk.core.api.models.BadRequestResponseType;
import com.fifa.connectid.sdk.core.api.models.PersonType;
import com.fifa.connectid.sdk.core.api.models.TooManyRequestsResponseType;
import com.google.common.reflect.TypeToken;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DataHoldersImpl
implements DataHolders {
    private DataHoldersService service;
    private FIFAConnectIDIDDirectoryV6Impl client;

    public DataHoldersImpl(Retrofit retrofit, FIFAConnectIDIDDirectoryV6Impl client) {
        this.service = (DataHoldersService)retrofit.create(DataHoldersService.class);
        this.client = client;
    }

    @Override
    public Object getByPersonfifaid(String personFifaId) {
        return ((ServiceResponse)this.getByPersonfifaidWithServiceResponseAsync(personFifaId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> getByPersonfifaidAsync(String personFifaId, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByPersonfifaidWithServiceResponseAsync(personFifaId), serviceCallback);
    }

    @Override
    public Observable<Object> getByPersonfifaidAsync(String personFifaId) {
        return this.getByPersonfifaidWithServiceResponseAsync(personFifaId).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getByPersonfifaidWithServiceResponseAsync(String personFifaId) {
        if (personFifaId == null) {
            throw new IllegalArgumentException("Parameter personFifaId is required and cannot be null.");
        }
        return this.service.getByPersonfifaid(personFifaId).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = DataHoldersImpl.this.getByPersonfifaidDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> getByPersonfifaidDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<String>>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object claimByPersonfifaid(String personFifaId) {
        return ((ServiceResponse)this.claimByPersonfifaidWithServiceResponseAsync(personFifaId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> claimByPersonfifaidAsync(String personFifaId, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.claimByPersonfifaidWithServiceResponseAsync(personFifaId), serviceCallback);
    }

    @Override
    public Observable<Object> claimByPersonfifaidAsync(String personFifaId) {
        return this.claimByPersonfifaidWithServiceResponseAsync(personFifaId).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> claimByPersonfifaidWithServiceResponseAsync(String personFifaId) {
        if (personFifaId == null) {
            throw new IllegalArgumentException("Parameter personFifaId is required and cannot be null.");
        }
        String xActorDetails = null;
        return this.service.claimByPersonfifaid(personFifaId, xActorDetails).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = DataHoldersImpl.this.claimByPersonfifaidDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object claimByPersonfifaid(String personFifaId, String xActorDetails) {
        return ((ServiceResponse)this.claimByPersonfifaidWithServiceResponseAsync(personFifaId, xActorDetails).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> claimByPersonfifaidAsync(String personFifaId, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.claimByPersonfifaidWithServiceResponseAsync(personFifaId, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> claimByPersonfifaidAsync(String personFifaId, String xActorDetails) {
        return this.claimByPersonfifaidWithServiceResponseAsync(personFifaId, xActorDetails).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> claimByPersonfifaidWithServiceResponseAsync(String personFifaId, String xActorDetails) {
        if (personFifaId == null) {
            throw new IllegalArgumentException("Parameter personFifaId is required and cannot be null.");
        }
        return this.service.claimByPersonfifaid(personFifaId, xActorDetails).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = DataHoldersImpl.this.claimByPersonfifaidDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> claimByPersonfifaidDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(301, new TypeToken<PersonType>(){}.getType()).register(400, new TypeToken<Void>(){}.getType()).register(403, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(410, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    static interface DataHoldersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.DataHolders getByPersonfifaid"})
        @GET(value="api/v6/dataholder/get")
        public Observable<Response<ResponseBody>> getByPersonfifaid(@Query(value="personFifaId") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.DataHolders claimByPersonfifaid"})
        @PUT(value="api/v6/dataholder/claim")
        public Observable<Response<ResponseBody>> claimByPersonfifaid(@Query(value="personFifaId") String var1, @Header(value="X-ActorDetails") String var2);
    }
}

