/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.api.implementation;

import com.fifa.connectid.sdk.core.api.Persons;
import com.fifa.connectid.sdk.core.api.implementation.FIFAConnectIDIDDirectoryV6Impl;
import com.fifa.connectid.sdk.core.api.models.AddRegistrationsRequestType;
import com.fifa.connectid.sdk.core.api.models.BadRequestResponseType;
import com.fifa.connectid.sdk.core.api.models.BulkDeactivateRegistrationsRequestType;
import com.fifa.connectid.sdk.core.api.models.BulkDeactivateRegistrationsResponseType;
import com.fifa.connectid.sdk.core.api.models.ConflictResponseType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesByFIFAIdRequestType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesOfRegisteredPersonResponseType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesRequestType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesResponseType;
import com.fifa.connectid.sdk.core.api.models.MergePersonsRequestType;
import com.fifa.connectid.sdk.core.api.models.PersonGetByPersonfifaidHeaders;
import com.fifa.connectid.sdk.core.api.models.PersonGetPrimaryDataProviderRegistrationByPersonfifaidHeaders;
import com.fifa.connectid.sdk.core.api.models.PersonType;
import com.fifa.connectid.sdk.core.api.models.RegisterPersonRequestType;
import com.fifa.connectid.sdk.core.api.models.RegisterResponseType;
import com.fifa.connectid.sdk.core.api.models.RegistrationType;
import com.fifa.connectid.sdk.core.api.models.TooManyRequestsResponseType;
import com.fifa.connectid.sdk.core.api.models.UnmergePersonsRequestType;
import com.fifa.connectid.sdk.core.api.models.UpdatePersonRequestType;
import com.fifa.connectid.sdk.core.api.models.UpdateRegistrationsRequestType;
import com.google.common.reflect.TypeToken;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class PersonsImpl
implements Persons {
    private PersonsService service;
    private FIFAConnectIDIDDirectoryV6Impl client;

    public PersonsImpl(Retrofit retrofit, FIFAConnectIDIDDirectoryV6Impl client) {
        this.service = (PersonsService)retrofit.create(PersonsService.class);
        this.client = client;
    }

    @Override
    public Object getByPersonfifaid(String personFifaId) {
        return ((ServiceResponseWithHeaders)this.getByPersonfifaidWithServiceResponseAsync(personFifaId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> getByPersonfifaidAsync(String personFifaId, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getByPersonfifaidWithServiceResponseAsync(personFifaId), serviceCallback);
    }

    @Override
    public Observable<Object> getByPersonfifaidAsync(String personFifaId) {
        return this.getByPersonfifaidWithServiceResponseAsync(personFifaId).map((Func1)new Func1<ServiceResponseWithHeaders<Object, PersonGetByPersonfifaidHeaders>, Object>(){

            public Object call(ServiceResponseWithHeaders<Object, PersonGetByPersonfifaidHeaders> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Object, PersonGetByPersonfifaidHeaders>> getByPersonfifaidWithServiceResponseAsync(String personFifaId) {
        if (personFifaId == null) {
            throw new IllegalArgumentException("Parameter personFifaId is required and cannot be null.");
        }
        return this.service.getByPersonfifaid(personFifaId).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Object, PersonGetByPersonfifaidHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Object, PersonGetByPersonfifaidHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders<Object, PersonGetByPersonfifaidHeaders> clientResponse = PersonsImpl.this.getByPersonfifaidDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Object, PersonGetByPersonfifaidHeaders> getByPersonfifaidDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PersonType>(){}.getType()).register(301, new TypeToken<PersonType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(410, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).buildWithHeaders(response, PersonGetByPersonfifaidHeaders.class);
    }

    @Override
    public Object getDuplicates(GetDuplicatesRequestType body) {
        return ((ServiceResponse)this.getDuplicatesWithServiceResponseAsync(body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> getDuplicatesAsync(GetDuplicatesRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDuplicatesWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> getDuplicatesAsync(GetDuplicatesRequestType body) {
        return this.getDuplicatesWithServiceResponseAsync(body).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getDuplicatesWithServiceResponseAsync(GetDuplicatesRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        String xActorDetails = null;
        return this.service.getDuplicates(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.getDuplicatesDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object getDuplicates(GetDuplicatesRequestType body, String xActorDetails) {
        return ((ServiceResponse)this.getDuplicatesWithServiceResponseAsync(body, xActorDetails).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> getDuplicatesAsync(GetDuplicatesRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDuplicatesWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> getDuplicatesAsync(GetDuplicatesRequestType body, String xActorDetails) {
        return this.getDuplicatesWithServiceResponseAsync(body, xActorDetails).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getDuplicatesWithServiceResponseAsync(GetDuplicatesRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        return this.service.getDuplicates(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.getDuplicatesDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> getDuplicatesDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GetDuplicatesResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object getDuplicatesByFIFAId(GetDuplicatesByFIFAIdRequestType body) {
        return ((ServiceResponse)this.getDuplicatesByFIFAIdWithServiceResponseAsync(body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> getDuplicatesByFIFAIdAsync(GetDuplicatesByFIFAIdRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDuplicatesByFIFAIdWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> getDuplicatesByFIFAIdAsync(GetDuplicatesByFIFAIdRequestType body) {
        return this.getDuplicatesByFIFAIdWithServiceResponseAsync(body).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getDuplicatesByFIFAIdWithServiceResponseAsync(GetDuplicatesByFIFAIdRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        String xActorDetails = null;
        return this.service.getDuplicatesByFIFAId(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.getDuplicatesByFIFAIdDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object getDuplicatesByFIFAId(GetDuplicatesByFIFAIdRequestType body, String xActorDetails) {
        return ((ServiceResponse)this.getDuplicatesByFIFAIdWithServiceResponseAsync(body, xActorDetails).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> getDuplicatesByFIFAIdAsync(GetDuplicatesByFIFAIdRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDuplicatesByFIFAIdWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> getDuplicatesByFIFAIdAsync(GetDuplicatesByFIFAIdRequestType body, String xActorDetails) {
        return this.getDuplicatesByFIFAIdWithServiceResponseAsync(body, xActorDetails).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getDuplicatesByFIFAIdWithServiceResponseAsync(GetDuplicatesByFIFAIdRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        return this.service.getDuplicatesByFIFAId(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.getDuplicatesByFIFAIdDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> getDuplicatesByFIFAIdDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GetDuplicatesOfRegisteredPersonResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object getPrimaryDataProviderRegistrationByPersonfifaid(String personFifaId) {
        return ((ServiceResponseWithHeaders)this.getPrimaryDataProviderRegistrationByPersonfifaidWithServiceResponseAsync(personFifaId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> getPrimaryDataProviderRegistrationByPersonfifaidAsync(String personFifaId, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getPrimaryDataProviderRegistrationByPersonfifaidWithServiceResponseAsync(personFifaId), serviceCallback);
    }

    @Override
    public Observable<Object> getPrimaryDataProviderRegistrationByPersonfifaidAsync(String personFifaId) {
        return this.getPrimaryDataProviderRegistrationByPersonfifaidWithServiceResponseAsync(personFifaId).map((Func1)new Func1<ServiceResponseWithHeaders<Object, PersonGetPrimaryDataProviderRegistrationByPersonfifaidHeaders>, Object>(){

            public Object call(ServiceResponseWithHeaders<Object, PersonGetPrimaryDataProviderRegistrationByPersonfifaidHeaders> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Object, PersonGetPrimaryDataProviderRegistrationByPersonfifaidHeaders>> getPrimaryDataProviderRegistrationByPersonfifaidWithServiceResponseAsync(String personFifaId) {
        if (personFifaId == null) {
            throw new IllegalArgumentException("Parameter personFifaId is required and cannot be null.");
        }
        return this.service.getPrimaryDataProviderRegistrationByPersonfifaid(personFifaId).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Object, PersonGetPrimaryDataProviderRegistrationByPersonfifaidHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Object, PersonGetPrimaryDataProviderRegistrationByPersonfifaidHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders<Object, PersonGetPrimaryDataProviderRegistrationByPersonfifaidHeaders> clientResponse = PersonsImpl.this.getPrimaryDataProviderRegistrationByPersonfifaidDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Object, PersonGetPrimaryDataProviderRegistrationByPersonfifaidHeaders> getPrimaryDataProviderRegistrationByPersonfifaidDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistrationType>(){}.getType()).register(301, new TypeToken<PersonType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(410, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).buildWithHeaders(response, PersonGetPrimaryDataProviderRegistrationByPersonfifaidHeaders.class);
    }

    @Override
    public Object register(RegisterPersonRequestType body) {
        return ((ServiceResponse)this.registerWithServiceResponseAsync(body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> registerAsync(RegisterPersonRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.registerWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> registerAsync(RegisterPersonRequestType body) {
        return this.registerWithServiceResponseAsync(body).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> registerWithServiceResponseAsync(RegisterPersonRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        String xActorDetails = null;
        return this.service.register(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.registerDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object register(RegisterPersonRequestType body, String xActorDetails) {
        return ((ServiceResponse)this.registerWithServiceResponseAsync(body, xActorDetails).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> registerAsync(RegisterPersonRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.registerWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> registerAsync(RegisterPersonRequestType body, String xActorDetails) {
        return this.registerWithServiceResponseAsync(body, xActorDetails).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> registerWithServiceResponseAsync(RegisterPersonRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        return this.service.register(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.registerDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> registerDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<RegisterResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(409, new TypeToken<GetDuplicatesResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object forceRegister(RegisterPersonRequestType body) {
        return ((ServiceResponse)this.forceRegisterWithServiceResponseAsync(body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> forceRegisterAsync(RegisterPersonRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.forceRegisterWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> forceRegisterAsync(RegisterPersonRequestType body) {
        return this.forceRegisterWithServiceResponseAsync(body).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> forceRegisterWithServiceResponseAsync(RegisterPersonRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        String xActorDetails = null;
        return this.service.forceRegister(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.forceRegisterDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object forceRegister(RegisterPersonRequestType body, String xActorDetails) {
        return ((ServiceResponse)this.forceRegisterWithServiceResponseAsync(body, xActorDetails).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> forceRegisterAsync(RegisterPersonRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.forceRegisterWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> forceRegisterAsync(RegisterPersonRequestType body, String xActorDetails) {
        return this.forceRegisterWithServiceResponseAsync(body, xActorDetails).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> forceRegisterWithServiceResponseAsync(RegisterPersonRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        return this.service.forceRegister(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.forceRegisterDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> forceRegisterDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<RegisterResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object updatePersonByForce(UpdatePersonRequestType body) {
        return ((ServiceResponse)this.updatePersonByForceWithServiceResponseAsync(body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> updatePersonByForceAsync(UpdatePersonRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.updatePersonByForceWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> updatePersonByForceAsync(UpdatePersonRequestType body) {
        return this.updatePersonByForceWithServiceResponseAsync(body).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> updatePersonByForceWithServiceResponseAsync(UpdatePersonRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        Boolean force = null;
        String xActorDetails = null;
        return this.service.updatePersonByForce(force, xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.updatePersonByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object updatePersonByForce(UpdatePersonRequestType body, Boolean force, String xActorDetails) {
        return ((ServiceResponse)this.updatePersonByForceWithServiceResponseAsync(body, force, xActorDetails).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> updatePersonByForceAsync(UpdatePersonRequestType body, Boolean force, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.updatePersonByForceWithServiceResponseAsync(body, force, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> updatePersonByForceAsync(UpdatePersonRequestType body, Boolean force, String xActorDetails) {
        return this.updatePersonByForceWithServiceResponseAsync(body, force, xActorDetails).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> updatePersonByForceWithServiceResponseAsync(UpdatePersonRequestType body, Boolean force, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        return this.service.updatePersonByForce(force, xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.updatePersonByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> updatePersonByForceDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PersonType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(409, new TypeToken<GetDuplicatesOfRegisteredPersonResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object merge(MergePersonsRequestType body) {
        return ((ServiceResponse)this.mergeWithServiceResponseAsync(body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> mergeAsync(MergePersonsRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.mergeWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> mergeAsync(MergePersonsRequestType body) {
        return this.mergeWithServiceResponseAsync(body).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> mergeWithServiceResponseAsync(MergePersonsRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        String xActorDetails = null;
        return this.service.merge(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.mergeDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object merge(MergePersonsRequestType body, String xActorDetails) {
        return ((ServiceResponse)this.mergeWithServiceResponseAsync(body, xActorDetails).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> mergeAsync(MergePersonsRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.mergeWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> mergeAsync(MergePersonsRequestType body, String xActorDetails) {
        return this.mergeWithServiceResponseAsync(body, xActorDetails).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> mergeWithServiceResponseAsync(MergePersonsRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        return this.service.merge(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.mergeDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> mergeDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PersonType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(409, new TypeToken<ConflictResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object unmerge(UnmergePersonsRequestType body) {
        return ((ServiceResponse)this.unmergeWithServiceResponseAsync(body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> unmergeAsync(UnmergePersonsRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.unmergeWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> unmergeAsync(UnmergePersonsRequestType body) {
        return this.unmergeWithServiceResponseAsync(body).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> unmergeWithServiceResponseAsync(UnmergePersonsRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        String xActorDetails = null;
        return this.service.unmerge(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.unmergeDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object unmerge(UnmergePersonsRequestType body, String xActorDetails) {
        return ((ServiceResponse)this.unmergeWithServiceResponseAsync(body, xActorDetails).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> unmergeAsync(UnmergePersonsRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.unmergeWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> unmergeAsync(UnmergePersonsRequestType body, String xActorDetails) {
        return this.unmergeWithServiceResponseAsync(body, xActorDetails).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> unmergeWithServiceResponseAsync(UnmergePersonsRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        return this.service.unmerge(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.unmergeDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> unmergeDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PersonType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(409, new TypeToken<ConflictResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object addRegistrationsByForce(AddRegistrationsRequestType body) {
        return ((ServiceResponse)this.addRegistrationsByForceWithServiceResponseAsync(body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> addRegistrationsByForceAsync(AddRegistrationsRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.addRegistrationsByForceWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> addRegistrationsByForceAsync(AddRegistrationsRequestType body) {
        return this.addRegistrationsByForceWithServiceResponseAsync(body).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> addRegistrationsByForceWithServiceResponseAsync(AddRegistrationsRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        Boolean force = null;
        String xActorDetails = null;
        return this.service.addRegistrationsByForce(force, xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.addRegistrationsByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object addRegistrationsByForce(AddRegistrationsRequestType body, Boolean force, String xActorDetails) {
        return ((ServiceResponse)this.addRegistrationsByForceWithServiceResponseAsync(body, force, xActorDetails).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> addRegistrationsByForceAsync(AddRegistrationsRequestType body, Boolean force, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.addRegistrationsByForceWithServiceResponseAsync(body, force, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> addRegistrationsByForceAsync(AddRegistrationsRequestType body, Boolean force, String xActorDetails) {
        return this.addRegistrationsByForceWithServiceResponseAsync(body, force, xActorDetails).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> addRegistrationsByForceWithServiceResponseAsync(AddRegistrationsRequestType body, Boolean force, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        return this.service.addRegistrationsByForce(force, xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.addRegistrationsByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> addRegistrationsByForceDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<PersonType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object updateRegistrationsByForce(UpdateRegistrationsRequestType body) {
        return ((ServiceResponse)this.updateRegistrationsByForceWithServiceResponseAsync(body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> updateRegistrationsByForceAsync(UpdateRegistrationsRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateRegistrationsByForceWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> updateRegistrationsByForceAsync(UpdateRegistrationsRequestType body) {
        return this.updateRegistrationsByForceWithServiceResponseAsync(body).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> updateRegistrationsByForceWithServiceResponseAsync(UpdateRegistrationsRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        Boolean force = null;
        String xActorDetails = null;
        return this.service.updateRegistrationsByForce(force, xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.updateRegistrationsByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object updateRegistrationsByForce(UpdateRegistrationsRequestType body, Boolean force, String xActorDetails) {
        return ((ServiceResponse)this.updateRegistrationsByForceWithServiceResponseAsync(body, force, xActorDetails).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> updateRegistrationsByForceAsync(UpdateRegistrationsRequestType body, Boolean force, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateRegistrationsByForceWithServiceResponseAsync(body, force, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> updateRegistrationsByForceAsync(UpdateRegistrationsRequestType body, Boolean force, String xActorDetails) {
        return this.updateRegistrationsByForceWithServiceResponseAsync(body, force, xActorDetails).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> updateRegistrationsByForceWithServiceResponseAsync(UpdateRegistrationsRequestType body, Boolean force, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        return this.service.updateRegistrationsByForce(force, xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.updateRegistrationsByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> updateRegistrationsByForceDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PersonType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object bulkDeactivateRegistrations(BulkDeactivateRegistrationsRequestType body) {
        return ((ServiceResponse)this.bulkDeactivateRegistrationsWithServiceResponseAsync(body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> bulkDeactivateRegistrationsAsync(BulkDeactivateRegistrationsRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.bulkDeactivateRegistrationsWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> bulkDeactivateRegistrationsAsync(BulkDeactivateRegistrationsRequestType body) {
        return this.bulkDeactivateRegistrationsWithServiceResponseAsync(body).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> bulkDeactivateRegistrationsWithServiceResponseAsync(BulkDeactivateRegistrationsRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        String xActorDetails = null;
        return this.service.bulkDeactivateRegistrations(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.bulkDeactivateRegistrationsDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object bulkDeactivateRegistrations(BulkDeactivateRegistrationsRequestType body, String xActorDetails) {
        return ((ServiceResponse)this.bulkDeactivateRegistrationsWithServiceResponseAsync(body, xActorDetails).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> bulkDeactivateRegistrationsAsync(BulkDeactivateRegistrationsRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.bulkDeactivateRegistrationsWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> bulkDeactivateRegistrationsAsync(BulkDeactivateRegistrationsRequestType body, String xActorDetails) {
        return this.bulkDeactivateRegistrationsWithServiceResponseAsync(body, xActorDetails).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> bulkDeactivateRegistrationsWithServiceResponseAsync(BulkDeactivateRegistrationsRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        return this.service.bulkDeactivateRegistrations(xActorDetails, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.bulkDeactivateRegistrationsDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> bulkDeactivateRegistrationsDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BulkDeactivateRegistrationsResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object getMergedSecondaryFifaIdsByPersonfifaid(String personFifaId) {
        return ((ServiceResponse)this.getMergedSecondaryFifaIdsByPersonfifaidWithServiceResponseAsync(personFifaId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> getMergedSecondaryFifaIdsByPersonfifaidAsync(String personFifaId, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMergedSecondaryFifaIdsByPersonfifaidWithServiceResponseAsync(personFifaId), serviceCallback);
    }

    @Override
    public Observable<Object> getMergedSecondaryFifaIdsByPersonfifaidAsync(String personFifaId) {
        return this.getMergedSecondaryFifaIdsByPersonfifaidWithServiceResponseAsync(personFifaId).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getMergedSecondaryFifaIdsByPersonfifaidWithServiceResponseAsync(String personFifaId) {
        if (personFifaId == null) {
            throw new IllegalArgumentException("Parameter personFifaId is required and cannot be null.");
        }
        return this.service.getMergedSecondaryFifaIdsByPersonfifaid(personFifaId).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = PersonsImpl.this.getMergedSecondaryFifaIdsByPersonfifaidDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> getMergedSecondaryFifaIdsByPersonfifaidDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<String>>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(410, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    static interface PersonsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons getByPersonfifaid"})
        @GET(value="api/v6/person/get")
        public Observable<Response<ResponseBody>> getByPersonfifaid(@Query(value="personFifaId") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons getDuplicates"})
        @POST(value="api/v6/person/getduplicates")
        public Observable<Response<ResponseBody>> getDuplicates(@Header(value="X-ActorDetails") String var1, @Body GetDuplicatesRequestType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons getDuplicatesByFIFAId"})
        @POST(value="api/v6/person/getduplicatesbyfifaid")
        public Observable<Response<ResponseBody>> getDuplicatesByFIFAId(@Header(value="X-ActorDetails") String var1, @Body GetDuplicatesByFIFAIdRequestType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons getPrimaryDataProviderRegistrationByPersonfifaid"})
        @GET(value="api/v6/person/getprimarydataproviderregistration")
        public Observable<Response<ResponseBody>> getPrimaryDataProviderRegistrationByPersonfifaid(@Query(value="personFifaId") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons register"})
        @POST(value="api/v6/person/register")
        public Observable<Response<ResponseBody>> register(@Header(value="X-ActorDetails") String var1, @Body RegisterPersonRequestType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons forceRegister"})
        @POST(value="api/v6/person/forceregister")
        public Observable<Response<ResponseBody>> forceRegister(@Header(value="X-ActorDetails") String var1, @Body RegisterPersonRequestType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons updatePersonByForce"})
        @POST(value="api/v6/person/updateperson")
        public Observable<Response<ResponseBody>> updatePersonByForce(@Query(value="force") Boolean var1, @Header(value="X-ActorDetails") String var2, @Body UpdatePersonRequestType var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons merge"})
        @POST(value="api/v6/person/merge")
        public Observable<Response<ResponseBody>> merge(@Header(value="X-ActorDetails") String var1, @Body MergePersonsRequestType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons unmerge"})
        @POST(value="api/v6/person/unmerge")
        public Observable<Response<ResponseBody>> unmerge(@Header(value="X-ActorDetails") String var1, @Body UnmergePersonsRequestType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons addRegistrationsByForce"})
        @POST(value="api/v6/person/addregistrations")
        public Observable<Response<ResponseBody>> addRegistrationsByForce(@Query(value="force") Boolean var1, @Header(value="X-ActorDetails") String var2, @Body AddRegistrationsRequestType var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons updateRegistrationsByForce"})
        @POST(value="api/v6/person/updateregistrations")
        public Observable<Response<ResponseBody>> updateRegistrationsByForce(@Query(value="force") Boolean var1, @Header(value="X-ActorDetails") String var2, @Body UpdateRegistrationsRequestType var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons bulkDeactivateRegistrations"})
        @POST(value="api/v6/person/bulkdeactivateregistrations")
        public Observable<Response<ResponseBody>> bulkDeactivateRegistrations(@Header(value="X-ActorDetails") String var1, @Body BulkDeactivateRegistrationsRequestType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Persons getMergedSecondaryFifaIdsByPersonfifaid"})
        @GET(value="api/v6/person/getmergedsecondaryfifaids")
        public Observable<Response<ResponseBody>> getMergedSecondaryFifaIdsByPersonfifaid(@Query(value="personFifaId") String var1);
    }
}

