/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.core.apimodelvalidation.DocumentValidationResult;
import com.fifa.connectid.sdk.core.apimodelvalidation.DocumentValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DocumentValidatorImpl
implements DocumentValidator {
    private final List<DocumentValidator> validators = new ArrayList<DocumentValidator>();

    public DocumentValidatorImpl(DocumentValidator ... validators) {
        Collections.addAll(this.validators, validators);
    }

    @Override
    public DocumentValidationResult validate(byte[] content) {
        DocumentValidationResult validationResult = new DocumentValidationResult();
        ArrayList<DocumentValidationResult> validationResults = this.RunValidators(content);
        if (this.AnyValidationPassed(validationResult, validationResults)) {
            return validationResult;
        }
        this.CollectErrorMessages(validationResult, validationResults);
        return validationResult;
    }

    private boolean AnyValidationPassed(DocumentValidationResult collectedResult, ArrayList<DocumentValidationResult> validationResults) {
        for (DocumentValidationResult result : validationResults) {
            if (!result.isValid()) continue;
            return true;
        }
        return false;
    }

    private void CollectErrorMessages(DocumentValidationResult collectedResult, ArrayList<DocumentValidationResult> validationResults) {
        String errors = validationResults.stream().filter(dvr -> !dvr.isValid()).map(dvr -> dvr.getMessage() + " ").collect(Collectors.joining("", "Provided content does not meet any validation criteria: ", ""));
        if (!errors.isEmpty()) {
            collectedResult.Failed(errors);
        }
    }

    @NotNull
    private ArrayList<DocumentValidationResult> RunValidators(byte[] content) {
        return this.validators.stream().map(validator -> validator.validate(content)).collect(Collectors.toCollection(ArrayList::new));
    }
}

