/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.api.models.FacilityLocalType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ContextTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.FieldTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.FifaIdValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.LocalNameTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.fc.ISO3166CountryCode;
import com.fifa.fc.ISO6392Type;
import com.fifa.fc.SimpleStatusType;

class FacilityLocalTypeValidator
implements ModelValidator<FacilityLocalType> {
    FacilityLocalTypeValidator() {
    }

    @Override
    public void validate(FacilityLocalType facility, String validationSubjectName) throws ValidationException {
        String typeName = FacilityLocalType.class.getSimpleName();
        validationSubjectName = ApiModelValidator.isNullOrWhiteSpace(validationSubjectName) ? typeName : validationSubjectName;
        ApiModelValidator.cannotBeNull(facility, validationSubjectName);
        ApiModelValidator.cannotBeNullOrWhitespace(facility.localName(), validationSubjectName + ".localName");
        ApiModelValidator.cannotBeNullOrWhitespace(facility.internationalName(), validationSubjectName + ".internationalName");
        FifaIdValidator fifaIdValidator = new FifaIdValidator();
        ApiModelValidator.validateAllowNull(facility.facilityFIFAId(), fifaIdValidator, validationSubjectName + ".facilityFIFAId");
        ApiModelValidator.validateAllowNull(facility.parentFacilityFIFAId(), fifaIdValidator, validationSubjectName + ".parentFacilityFIFAId");
        ApiModelValidator.validateDoNotAllowNull(facility.organisationFIFAId(), fifaIdValidator, validationSubjectName + ".organisationFIFAId");
        ApiModelValidator.mustMatchEnumValue(facility.status(), SimpleStatusType.class, validationSubjectName + ".status");
        ApiModelValidator.mustMatchSchemaEnumValue(facility.localLanguage(), ISO6392Type.class, validationSubjectName + ".localLanguage");
        ApiModelValidator.mustMatchSchemaEnumValue(facility.localCountry(), ISO3166CountryCode.class, validationSubjectName + ".localCountry");
        ContextTypeValidator.validate(facility.officialAddress(), validationSubjectName + ".officialAddress");
        ApiModelValidator.validateAllInCollectionIfNotNull(facility.localFacilityName(), new LocalNameTypeValidator(), validationSubjectName + ".localFacilityName");
        ApiModelValidator.validateAllInCollectionIfNotNull(facility.field(), new FieldTypeValidator(), validationSubjectName + ".field");
    }
}

