/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.api.models.FieldType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.fc.DisciplineType;
import com.fifa.fc.GroundNatureType;

class FieldTypeValidator
implements ModelValidator<FieldType> {
    FieldTypeValidator() {
    }

    @Override
    public void validate(FieldType field, String validationSubjectName) throws ValidationException {
        String typeName = FieldType.class.getSimpleName();
        validationSubjectName = ApiModelValidator.isNullOrWhiteSpace(validationSubjectName) ? typeName : validationSubjectName;
        ApiModelValidator.cannotBeNull(field, validationSubjectName);
        ApiModelValidator.mustBeGreaterOrEqual(field.orderNumber(), 1, validationSubjectName + ".orderNumber");
        ApiModelValidator.mustBeGreaterOrEqual(field.capacity(), 0, validationSubjectName + ".capacity");
        ApiModelValidator.mustMatchEnumValue(field.discipline(), DisciplineType.class, validationSubjectName + ".discipline");
        ApiModelValidator.mustMatchEnumValue(field.groundNature(), GroundNatureType.class, validationSubjectName + ".groundNature");
    }
}

