/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.api.models.LocalNameType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.fc.ISO6392Type;

class LocalNameTypeValidator
implements ModelValidator<LocalNameType> {
    LocalNameTypeValidator() {
    }

    @Override
    public void validate(LocalNameType localName, String validationSubjectName) throws ValidationException {
        String typeName = LocalNameType.class.getSimpleName();
        validationSubjectName = ApiModelValidator.isNullOrWhiteSpace(validationSubjectName) ? typeName : validationSubjectName;
        ApiModelValidator.cannotBeNull(localName, validationSubjectName);
        ApiModelValidator.cannotBeNullOrWhitespace(localName.name(), validationSubjectName + ".name");
        String languagePropertyName = validationSubjectName + ".language";
        ApiModelValidator.cannotBeNullOrWhitespace(localName.language(), languagePropertyName);
        ApiModelValidator.mustMatchSchemaEnumValue(localName.language(), ISO6392Type.class, languagePropertyName);
    }
}

