/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.api.models.OrganisationLocalType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ComplianceAndPaymentManagerTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ContextTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.EmailValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.FifaIdValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.LocalNameTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.NationalIdentifierTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.PictureTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.SupportedDisciplineTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.WebAddressValidator;
import com.fifa.fc.ClubTrainingCategoryType;
import com.fifa.fc.ISO3166CountryCode;
import com.fifa.fc.ISO6392Type;
import com.fifa.fc.OrganisationNatureType;
import com.fifa.fc.SimpleStatusType;

class OrganisationLocalTypeValidator
implements ModelValidator<OrganisationLocalType> {
    OrganisationLocalTypeValidator() {
    }

    @Override
    public void validate(OrganisationLocalType organisation, String validationSubjectName) throws ValidationException {
        String typeName = OrganisationLocalType.class.getSimpleName();
        validationSubjectName = ApiModelValidator.isNullOrWhiteSpace(validationSubjectName) ? typeName : validationSubjectName;
        ApiModelValidator.cannotBeNull(organisation, validationSubjectName);
        ApiModelValidator.cannotBeNullOrWhitespace(organisation.internationalName(), validationSubjectName + ".internationalName");
        ApiModelValidator.cannotBeNullOrWhitespace(organisation.localName(), validationSubjectName + ".localName");
        FifaIdValidator fifaIdValidator = new FifaIdValidator();
        ApiModelValidator.validateAllowNull(organisation.organisationFIFAId(), fifaIdValidator, validationSubjectName + ".organisationFIFAId");
        ApiModelValidator.validateAllowNull(organisation.parentOrganisationFIFAId(), fifaIdValidator, validationSubjectName + ".parentOrganisationFIFAId");
        ApiModelValidator.mustMatchEnumValue(organisation.status(), SimpleStatusType.class, validationSubjectName + ".status");
        ApiModelValidator.mustMatchSchemaEnumValue(organisation.localLanguage(), ISO6392Type.class, validationSubjectName + ".localLanguage");
        ApiModelValidator.mustMatchSchemaEnumValue(organisation.localCountry(), ISO3166CountryCode.class, validationSubjectName + ".localCountry");
        ApiModelValidator.mustMatchEnumValue(organisation.organisationNature(), OrganisationNatureType.class, validationSubjectName + ".organisationNature");
        ContextTypeValidator.validate(organisation.officialAddress(), validationSubjectName + ".officialAddress");
        ApiModelValidator.validateAllowNull(organisation.webAddress(), new WebAddressValidator(), validationSubjectName + ".webAddress");
        ApiModelValidator.validateAllowNull(organisation.email(), new EmailValidator(), validationSubjectName + ".email");
        ApiModelValidator.validateAllowNull(organisation.logo(), new PictureTypeValidator(), validationSubjectName + ".logo");
        ApiModelValidator.validateAllInCollectionIfNotNull(organisation.nationalIdentifier(), new NationalIdentifierTypeValidator(), validationSubjectName + ".nationalIdentifier");
        ApiModelValidator.validateAllInCollectionIfNotNull(organisation.localOrganisationName(), new LocalNameTypeValidator(), validationSubjectName + ".localOrganisationName");
        ApiModelValidator.validateAllInCollectionIfNotNull(organisation.supportedDiscipline(), new SupportedDisciplineTypeValidator(), validationSubjectName + ".supportedDiscipline");
        ApiModelValidator.mustBeNullOrMatchEnumValue(organisation.clubTrainingCategory(), ClubTrainingCategoryType.class, validationSubjectName + ".clubTrainingCategory");
        ApiModelValidator.validateAllowNull(organisation.complianceAndPaymentManager(), new ComplianceAndPaymentManagerTypeValidator(), validationSubjectName + ".complianceAndPaymentManager");
    }
}

