/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.api.models.PersonType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.MatchOfficialRegistrationTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.OrganisationOfficialRegistrationTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.PlayerRegistrationTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.TeamOfficialRegistrationTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ValidationConstants;
import com.fifa.fc.GenderType;

class PersonTypeValidator
implements ModelValidator<PersonType> {
    PersonTypeValidator() {
    }

    @Override
    public void validate(PersonType person, String validationSubjectName) throws ValidationException {
        String typeName = PersonType.class.getSimpleName();
        validationSubjectName = ApiModelValidator.isNullOrWhiteSpace(validationSubjectName) ? typeName : validationSubjectName;
        ApiModelValidator.cannotBeNull(person, validationSubjectName);
        ApiModelValidator.mustBeNullOrMatchEnumValue(person.gender(), GenderType.class, validationSubjectName + ".gender");
        ApiModelValidator.mustBeGreaterOrEqual(person.dateOfBirth(), ValidationConstants.DATE_OF_BIRTH_LOWER_BOUNDARY, validationSubjectName + ".dateOfBirth");
        ApiModelValidator.validateAllInCollectionIfNotNull(person.playerRegistrations(), new PlayerRegistrationTypeValidator(), validationSubjectName + ".playerRegistrations");
        ApiModelValidator.validateAllInCollectionIfNotNull(person.matchOfficialRegistrations(), new MatchOfficialRegistrationTypeValidator(), validationSubjectName + ".matchOfficialRegistrations");
        ApiModelValidator.validateAllInCollectionIfNotNull(person.teamOfficialRegistrations(), new TeamOfficialRegistrationTypeValidator(), validationSubjectName + ".teamOfficialRegistrations");
        ApiModelValidator.validateAllInCollectionIfNotNull(person.organisationOfficialRegistrations(), new OrganisationOfficialRegistrationTypeValidator(), validationSubjectName + ".organisationOfficialRegistrations");
    }
}

