/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.api.models.PictureEmbeddedType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.DocumentValidationResult;
import com.fifa.connectid.sdk.core.apimodelvalidation.DocumentValidatorImpl;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.PictureValidator;

class PictureEmbeddedTypeValidator
implements ModelValidator<PictureEmbeddedType> {
    PictureEmbeddedTypeValidator() {
    }

    @Override
    public void validate(PictureEmbeddedType pictureEmbedded, String validationSubjectName) throws ValidationException {
        String typeName = PictureEmbeddedType.class.getSimpleName();
        validationSubjectName = ApiModelValidator.isNullOrWhiteSpace(validationSubjectName) ? typeName : validationSubjectName;
        ApiModelValidator.cannotBeNull(pictureEmbedded, validationSubjectName);
        ApiModelValidator.cannotBeNullOrWhitespace(pictureEmbedded.contentType(), validationSubjectName + ".contentType");
        String valuePropertyName = validationSubjectName + ".value";
        ApiModelValidator.cannotBeNull(pictureEmbedded.value(), valuePropertyName);
        this.validateImage(pictureEmbedded.value(), valuePropertyName);
    }

    private void validateImage(byte[] content, String validationSubjectName) throws ValidationException {
        DocumentValidationResult result = new DocumentValidatorImpl(new PictureValidator()).validate(content);
        if (!result.isValid()) {
            throw new ValidationException(String.format("%s must be a valid image.", validationSubjectName));
        }
    }
}

