/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.errorhandling;

import com.fifa.connectid.sdk.core.FifaDuplicateOfRegisteredPersonFoundException;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesOfRegisteredPersonResponseType;
import com.fifa.connectid.sdk.core.api.models.PersonDuplicateType;
import com.fifa.connectid.sdk.core.enhancements.DuplicateExceptionMessageFormatter;
import com.fifa.connectid.sdk.core.errorhandling.ErrorResponseHandler;
import com.microsoft.rest.ServiceResponse;
import java.util.ArrayList;

public class DuplicateOfRegisteredPersonFoundHandler
implements ErrorResponseHandler {
    @Override
    public void Handle(ServiceResponse<Object> serviceResponse) throws FifaDuplicateOfRegisteredPersonFoundException {
        Object body = serviceResponse.body();
        ArrayList<String> ids = new ArrayList<String>();
        if (serviceResponse.response().code() == 409 && body instanceof GetDuplicatesOfRegisteredPersonResponseType) {
            GetDuplicatesOfRegisteredPersonResponseType responseBody = (GetDuplicatesOfRegisteredPersonResponseType)body;
            if (responseBody.duplicates() != null && !responseBody.duplicates().isEmpty()) {
                for (PersonDuplicateType duplicate : responseBody.duplicates()) {
                    ids.add(duplicate.personFifaId());
                }
            }
            throw new FifaDuplicateOfRegisteredPersonFoundException(DuplicateExceptionMessageFormatter.format(ids), responseBody, serviceResponse);
        }
    }
}

