/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.errorhandling;

import com.fifa.connectid.sdk.core.FifaConnectIdException;
import com.fifa.connectid.sdk.core.UnauthorizedException;
import com.fifa.connectservicebus.sdk.AuthenticationException;
import com.fifa.connectservicebus.sdk.enhancements.ExceptionExtensions;
import com.microsoft.aad.msal4j.MsalServiceException;
import com.microsoft.rest.RestException;

public class ExceptionHandlingPolicy {
    public static void handleServiceResponseFailure(Exception exception, FifaConnectIdException defaultException) throws AuthenticationException, FifaConnectIdException {
        RestException serviceException;
        if (exception instanceof RestException && (serviceException = (RestException)exception).response().code() == 401) {
            throw new UnauthorizedException("Unauthorized", null);
        }
        if (MsalServiceException.class.isInstance(exception) || ExceptionExtensions.containsSpecificInnerException((Exception)exception, MsalServiceException.class)) {
            throw new AuthenticationException("Authentication failed", (Throwable)exception);
        }
        throw defaultException;
    }
}

