/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.errorhandling;

import com.fifa.connectid.sdk.core.TooManyRequestsException;
import com.fifa.connectid.sdk.core.api.models.TooManyRequestsResponseType;
import com.fifa.connectid.sdk.core.errorhandling.ConnectIdHeaders;
import com.fifa.connectid.sdk.core.errorhandling.ErrorResponseHandler;
import com.microsoft.rest.ServiceResponse;

public class TooManyRequestsHandler
implements ErrorResponseHandler {
    @Override
    public void Handle(ServiceResponse<Object> serviceResponse) throws TooManyRequestsException {
        TooManyRequestsResponseType response = null;
        if (serviceResponse.body() instanceof TooManyRequestsResponseType) {
            response = (TooManyRequestsResponseType)serviceResponse.body();
        }
        String retryAfterHeaderValue = serviceResponse.response().headers().get(ConnectIdHeaders.retryAfter);
        Integer retryAfter = this.parseIntOrNull(retryAfterHeaderValue);
        if (response != null && response.statusCode() == 429 && retryAfter != null) {
            throw new TooManyRequestsException(response.message(), retryAfter, serviceResponse);
        }
    }

    private Integer parseIntOrNull(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

