/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.hashing;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.ConnectIdEnvironment;
import com.fifa.connectid.sdk.core.FifaConnectIdException;
import com.fifa.connectid.sdk.core.FifaEntityNotFoundException;
import com.fifa.connectid.sdk.core.ServiceResponseUtils;
import com.fifa.connectid.sdk.core.UnauthorizedException;
import com.fifa.connectid.sdk.core.api.Hashs;
import com.fifa.connectid.sdk.core.api.implementation.FIFAConnectIDHashingV6Impl;
import com.fifa.connectid.sdk.core.api.implementation.HashsImpl;
import com.fifa.connectid.sdk.core.api.models.HashedNameType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.PersonNameValidator;
import com.fifa.connectid.sdk.core.enhancements.ObjectFormatter;
import com.fifa.connectid.sdk.core.errorhandling.ErrorResponseHandler;
import com.fifa.connectid.sdk.core.errorhandling.ExceptionHandlingPolicy;
import com.fifa.connectid.sdk.core.hashing.HashingServiceClient;
import com.fifa.connectid.sdk.core.xmlparser.models.PersonName;
import com.fifa.connectservicebus.sdk.AuthenticationException;
import com.fifa.connectservicebus.sdk.HttpClientFactory;
import com.fifa.connectservicebus.sdk.ProxySettings;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationInterceptor;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationService;
import com.fifa.connectservicebus.sdk.logging.Logger;
import com.microsoft.rest.ServiceResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;

public class HashingServiceClientImpl
implements HashingServiceClient {
    private static final PersonNameValidator VALIDATOR = new PersonNameValidator();
    private final Logger logger;
    private final Hashs hashOperations;
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(60L);

    public HashingServiceClientImpl(Hashs hashOperations, Logger logger) {
        if (hashOperations == null) {
            throw new IllegalArgumentException("hashOperations parameter cannot be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("logger parameter cannot be null");
        }
        this.hashOperations = hashOperations;
        this.logger = logger;
    }

    public static HashingServiceClientImpl CreateSyncClient(ConnectIdEnvironment connectIdEnvironment, AuthenticationService authenticationService, Logger logger, ProxySettings proxySettings) {
        Retrofit retrofit = HashingServiceClientImpl.buildRetrofitClient(connectIdEnvironment, authenticationService, proxySettings);
        HashsImpl hashOperations = new HashsImpl(retrofit, new FIFAConnectIDHashingV6Impl(connectIdEnvironment.HashingServiceUrl));
        return new HashingServiceClientImpl(hashOperations, logger);
    }

    private static Retrofit buildRetrofitClient(ConnectIdEnvironment connectIdEnvironment, AuthenticationService authenticationService, ProxySettings proxySettings) {
        if (connectIdEnvironment == null) {
            throw new IllegalArgumentException("connectIdEnvironment parameter cannot be null");
        }
        if (authenticationService == null) {
            throw new IllegalArgumentException("authenticationService parameter cannot be null");
        }
        OkHttpClient client = HttpClientFactory.create((ProxySettings)proxySettings, (Duration)REQUEST_TIMEOUT, builder -> builder.addInterceptor((Interceptor)new AuthenticationInterceptor(authenticationService)));
        return new Retrofit.Builder().baseUrl(connectIdEnvironment.HashingServiceUrl).client(client).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).build();
    }

    @Override
    public List<HashedNameType> computeHashes(List<PersonName> personNames, boolean readOnly) throws FifaConnectIdException, AuthenticationException, ValidationException {
        if (personNames == null) {
            throw new IllegalArgumentException("personNames parameter cannot be null");
        }
        ApiModelValidator.validateAllInCollection(personNames, VALIDATOR, "personNames");
        this.logger.debug("Computing hashes for person names: %s", new Object[]{ObjectFormatter.toString(personNames)});
        ArrayList<HashedNameType> allHashes = new ArrayList<HashedNameType>();
        for (PersonName ps : personNames) {
            allHashes.addAll(this.computeHashes(ps, readOnly));
        }
        List<HashedNameType> hashes = allHashes.stream().sorted(Comparator.comparingDouble(HashedNameType::proximityScore).reversed()).collect(Collectors.toMap(HashedNameType::hash, hash -> hash, (hashWithHigherScore, hashWithLowerScore) -> hashWithHigherScore)).values().stream().collect(Collectors.toList());
        this.logger.debug("Hashes computed. Number of hashes generated: %d", new Object[]{hashes.size()});
        return hashes;
    }

    private List<HashedNameType> computeHashes(PersonName personName, boolean readOnly) throws AuthenticationException, UnauthorizedException, FifaConnectIdException, FifaEntityNotFoundException {
        this.logger.debug("Computing person name hash for: '%s'", new Object[]{personName.toString()});
        ServiceResponse result = null;
        try {
            String preferHeaderValue = readOnly ? "read-only" : null;
            result = (ServiceResponse)this.hashOperations.computeByRequestWithServiceResponseAsync(personName.getLastName(), personName.getFirstName(), preferHeaderValue).toBlocking().single();
            this.logger.debug("Received a response from the hashing service with status code: %d", new Object[]{result.response().code()});
        }
        catch (Exception e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to compute hashes for person: " + personName.getFirstName() + " " + personName.getLastName(), e));
        }
        Class<List> clazz = List.class;
        return ServiceResponseUtils.extractResult((ServiceResponse<Object>)result, clazz, 200, new ErrorResponseHandler[0]);
    }
}

