/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.xmlparser.models;

import com.fifa.connectid.sdk.core.api.models.PersonType;
import com.fifa.connectid.sdk.core.enhancements.ObjectFormatter;
import com.fifa.connectid.sdk.core.xmlparser.models.PersonName;
import com.fifa.connectid.sdk.core.xmlparser.models.PersonNameComparer;
import com.fifa.connectid.sdk.core.xmlparser.models.PersonNameComparerImpl;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;

public class PersonData {
    private List<PersonName> names;
    private PersonType person;
    private PersonNameComparer personNameComparer;

    public PersonData(List<PersonName> names, PersonType person, PersonNameComparer personNameComparer) {
        this.personNameComparer = personNameComparer;
        this.names = this.getDistinctNames(names);
        this.person = person;
    }

    public PersonData(List<PersonName> names, PersonType person) {
        this(names, person, new PersonNameComparerImpl());
    }

    public List<PersonName> getNames() {
        return this.names;
    }

    public void setNames(List<PersonName> names) {
        this.names = names;
    }

    public PersonType getPerson() {
        return this.person;
    }

    public void setPerson(PersonType person) {
        this.person = person;
    }

    public String toJsonString() {
        return ObjectFormatter.toJson(this);
    }

    public String toString() {
        return Joiner.on((String)", ").join(this.names) + " (" + this.person.dateOfBirth() + ", " + this.person.gender() + ")";
    }

    private List<PersonName> getDistinctNames(List<PersonName> names) {
        ArrayList<PersonName> distinctNames = new ArrayList<PersonName>();
        for (PersonName name : names) {
            if (name == null || this.any(distinctNames, name)) continue;
            distinctNames.add(name);
        }
        return distinctNames;
    }

    private boolean any(List<PersonName> collection, PersonName element) {
        for (PersonName x : collection) {
            if (!this.personNameComparer.equals(x, element)) continue;
            return true;
        }
        return false;
    }
}

