/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.xmlserializer;

import com.fifa.connectid.sdk.core.XmlDeserializationException;
import com.fifa.connectid.sdk.core.xmlserializer.XmlSerializer;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JaxbXmlSerializer<Item extends Serializable>
implements XmlSerializer<Item> {
    private final Class<Item> itemClass;

    public JaxbXmlSerializer(Class<Item> itemClass) {
        this.itemClass = itemClass;
    }

    @Override
    public String serialize(Item item) throws IOException, JAXBException {
        JAXBContext ctx = this.getJAXBContext();
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal(item, (Writer)stringWriter);
        String xml = stringWriter.toString();
        stringWriter.close();
        return xml;
    }

    @Override
    public Item deserialize(String serialized) throws XmlDeserializationException {
        try {
            JAXBContext jaxbContext = this.getJAXBContext();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (Item)((Serializable)this.itemClass.cast(unmarshaller.unmarshal((Reader)new StringReader(serialized))));
        }
        catch (Exception ex) {
            throw new XmlDeserializationException(serialized, String.format("XML to %s deserialization failed.", this.itemClass.getName()), ex);
        }
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        ClassLoader loader = this.itemClass.getClassLoader();
        String contextPath = "com.fifa.fc";
        return JAXBContext.newInstance((String)contextPath, (ClassLoader)loader);
    }
}

