/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.xmlserializer;

import com.fifa.connectid.sdk.core.XmlDeserializationException;
import com.fifa.connectid.sdk.core.XmlSerializationException;
import com.fifa.connectid.sdk.core.xmlserializer.XmlSerializer;
import com.fifa.connectid.sdk.core.xsdschemavalidator.ValidationResult;
import com.fifa.connectid.sdk.core.xsdschemavalidator.XmlValidationError;
import com.fifa.connectid.sdk.core.xsdschemavalidator.XsdSchemaValidator;
import java.io.IOException;
import java.util.function.Function;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

public class ValidatingXmlSerializer<Item>
implements XmlSerializer<Item> {
    private final XmlSerializer<Item> xmlSerializer;
    private final Function<Item, String> itemToString;
    private final XsdSchemaValidator xsdSchemaValidator;

    public ValidatingXmlSerializer(XmlSerializer<Item> xmlSerializer, Function<Item, String> itemToString) {
        this.xmlSerializer = xmlSerializer;
        this.itemToString = itemToString;
        this.xsdSchemaValidator = new XsdSchemaValidator();
    }

    @Override
    public String serialize(Item item) throws IOException, XmlSerializationException, SAXException, JAXBException {
        String xml = this.xmlSerializer.serialize(item);
        this.validateAgainstXSD(xml, errors -> {
            throw new XmlSerializationException("XML serialization failed for: " + this.itemToString.apply(item), errors, xml);
        });
        return xml;
    }

    @Override
    public Item deserialize(String xml) throws XmlDeserializationException, IOException, SAXException {
        this.validateAgainstXSD(xml, errors -> {
            throw new XmlDeserializationException(xml, "XML deserialization failed.", errors);
        });
        return this.xmlSerializer.deserialize(xml);
    }

    private <T extends Exception> void validateAgainstXSD(String xml, ValidationCallBackInterface<T> callBack) throws T, IOException, SAXException {
        ValidationResult validationResult = this.xsdSchemaValidator.validate(xml);
        if (!validationResult.isValid()) {
            callBack.invoke(validationResult.getErrors());
        }
    }

    @FunctionalInterface
    private static interface ValidationCallBackInterface<T extends Throwable> {
        public void invoke(XmlValidationError[] var1) throws T;
    }
}

