/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.xsdschemavalidator;

import com.fifa.connectid.sdk.core.xsdschemavalidator.Input;
import com.fifa.connectid.sdk.util.ResourcePath;
import com.fifa.connectid.sdk.util.ResourceReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class XsdResourceResolver
implements LSResourceResolver {
    private final String schemaBasePath;
    private final Map<String, String> pathMap = new HashMap<String, String>();

    public XsdResourceResolver(String schemaBasePath) {
        this.schemaBasePath = schemaBasePath;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (systemId.startsWith("http:")) {
            return null;
        }
        String baseResourceName = null;
        String baseResourcePath = null;
        String currentResourceName = systemId.substring(systemId.lastIndexOf("/") + 1);
        if (!this.pathMap.containsKey(currentResourceName)) {
            if (baseURI != null) {
                baseResourceName = baseURI.substring(baseURI.lastIndexOf("/") + 1);
            }
            if (systemId.startsWith("./")) {
                systemId = systemId.substring(2, systemId.length());
            }
            baseResourcePath = this.pathMap.containsKey(baseResourceName) ? this.pathMap.get(baseResourceName) : this.schemaBasePath;
            String normalizedPath = this.getNormalizedPath(baseResourcePath, systemId);
            ResourceReader resourceReader = new ResourceReader();
            InputStream resourceAsStream = resourceReader.readToStream(ResourcePath.parse(normalizedPath));
            if (systemId.contains("/")) {
                this.pathMap.put(currentResourceName, normalizedPath.substring(0, normalizedPath.lastIndexOf("/") + 1));
            } else {
                this.pathMap.put(systemId, baseResourcePath);
            }
            Scanner s = new Scanner(resourceAsStream).useDelimiter("\\A");
            String s1 = s.next().replaceAll("\\n", " ").replace("\\t", " ").replaceAll("\\s+", " ").replaceAll("[^\\x20-\\x7e]", "");
            ByteArrayInputStream is = new ByteArrayInputStream(s1.getBytes());
            return new Input(publicId, systemId, is);
        }
        return null;
    }

    private String getNormalizedPath(String basePath, String relativePath) {
        if (!relativePath.startsWith("../")) {
            return basePath + relativePath;
        }
        while (relativePath.startsWith("../")) {
            basePath = basePath.substring(0, basePath.substring(0, basePath.length() - 1).lastIndexOf("/") + 1);
            relativePath = relativePath.substring(3);
        }
        return basePath + relativePath;
    }
}

