/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.messageHandlers;

import com.fifa.connectid.sdk.CompositeMessageValidator;
import com.fifa.connectid.sdk.CorrelationIdBasedItemContainer;
import com.fifa.connectid.sdk.messageHandlers.MessageHandler;
import com.fifa.connectid.sdk.messageHandlers.MessageHandlerExtensions;
import com.fifa.connectservicebus.sdk.Message;
import com.fifa.connectservicebus.sdk.StringUtils;
import java.util.function.Function;

public class CorrelationIdContainerBasedMessageHandler<ConfirmationMessageReceived>
implements MessageHandler {
    private final String messageType;
    private final CorrelationIdBasedItemContainer<ConfirmationMessageReceived> responsesCache;
    private final Function<String, ConfirmationMessageReceived> createMessageReceived;
    private final CompositeMessageValidator messageValidator;

    public CorrelationIdContainerBasedMessageHandler(String messageType, CorrelationIdBasedItemContainer<ConfirmationMessageReceived> responsesCache, Function<String, ConfirmationMessageReceived> createMessageReceived) {
        this.messageType = messageType;
        this.responsesCache = responsesCache;
        this.createMessageReceived = createMessageReceived;
        this.messageValidator = new CompositeMessageValidator((message, compositeErrorBuilder) -> {
            String correlationId = message.getProperty("correlationId");
            compositeErrorBuilder.addMessageForCase(StringUtils.isNullOrEmpty((String)correlationId), "The 'correlationId' property cannot be null or empty.");
        });
    }

    @Override
    public boolean canHandle(String messageType) {
        return messageType.equals(this.messageType);
    }

    @Override
    public void handle(String messageType, Message message) throws Exception {
        this.messageValidator.validate(message);
        String correlationId = message.getProperty("correlationId");
        String xml = CorrelationIdContainerBasedMessageHandler.deserialize(message.getContent());
        this.responsesCache.put(correlationId, this.createMessageReceived.apply(xml));
    }

    private static String deserialize(byte[] bytes) {
        return bytes.length > 0 ? new String(bytes) : null;
    }

    public String toString() {
        return MessageHandlerExtensions.fullNameWithMessageType(this, this.messageType);
    }
}

