/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.messageHandlers;

import com.fifa.connectid.sdk.CompositeErrorBuilder;
import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.xmlserializer.PersonLocalXmlSerializer;
import com.fifa.connectid.sdk.core.xmlserializer.PersonLocalXmlSerializerImpl;
import com.fifa.connectid.sdk.messageHandlers.MessageHandler;
import com.fifa.connectid.sdk.messageHandlers.MessageHandlerExtensions;
import com.fifa.connectid.sdk.messageHandlers.PersonLocalReceivedHandler;
import com.fifa.connectservicebus.sdk.Message;
import com.fifa.connectservicebus.sdk.StringUtils;
import com.fifa.fc.PersonLocal;
import java.nio.charset.StandardCharsets;

public class PersonLocalMessageHandler
implements MessageHandler {
    private final PersonLocalReceivedHandler handler;
    private final String handledMessageType;
    private final PersonLocalXmlSerializer personLocalXmlSerializer;

    public PersonLocalMessageHandler(PersonLocalReceivedHandler personLocalReceivedHandler, String handledMessageType) {
        this.handler = personLocalReceivedHandler;
        this.handledMessageType = handledMessageType;
        this.personLocalXmlSerializer = new PersonLocalXmlSerializerImpl();
    }

    @Override
    public boolean canHandle(String messageType) {
        return messageType.equals(this.handledMessageType);
    }

    @Override
    public void handle(String messageType, Message message) throws Exception {
        CompositeErrorBuilder errorBuilder;
        String errors;
        String sender = message.getSender();
        String xml = null;
        byte[] content = message.getContent();
        if (content != null) {
            xml = new String(content, StandardCharsets.UTF_8);
        }
        if ((errors = (errorBuilder = new CompositeErrorBuilder()).addMessageForCase(StringUtils.isNullOrEmpty((String)sender), "Invalid PersonLocal message received - there was no sender specified.").addMessageForCase(StringUtils.isNullOrEmpty((String)xml), "Invalid PersonLocal message received - there was no content.").build()) != null) {
            throw new ValidationException(errors);
        }
        PersonLocal personLocal = this.personLocalXmlSerializer.deserialize(xml);
        this.handler.handle(personLocal, sender);
    }

    public String toString() {
        return MessageHandlerExtensions.fullNameWithMessageType(this, this.handledMessageType);
    }
}

