/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.notifications;

import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.FifaIdValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.connectid.sdk.messageHandlers.MessageHandler;
import com.fifa.connectid.sdk.messageHandlers.MessageHandlerExtensions;
import com.fifa.connectid.sdk.notifications.GenderChangedNotification;
import com.fifa.connectid.sdk.notifications.GenderChangedNotificationDto;
import com.fifa.connectid.sdk.notifications.GenderChangedNotificationDtoToModelConverter;
import com.fifa.connectid.sdk.notifications.GenderChangedNotificationHandler;
import com.fifa.connectid.sdk.notifications.MessageToDtoConverter;
import com.fifa.connectservicebus.sdk.Message;
import com.fifa.fc.GenderType;

public class GenderChangedMessageHandler
implements MessageHandler {
    private static final String SUPPORTED_MESSAGE_TYPE = "gender-changed-notification";
    private final GenderChangedNotificationHandler notificationHandler;
    private final ModelValidator<GenderChangedNotificationDto> dtoValidator;
    private final MessageToDtoConverter<GenderChangedNotificationDto> messageToDtoConverter;

    public GenderChangedMessageHandler(GenderChangedNotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
        this.messageToDtoConverter = new MessageToDtoConverter<GenderChangedNotificationDto>(GenderChangedNotificationDto.class);
        FifaIdValidator fifaIdValidator = new FifaIdValidator();
        this.dtoValidator = (validationSubject, validationSubjectName) -> {
            fifaIdValidator.validate(validationSubject.getPersonFIFAId(), "personFIFAId");
            ApiModelValidator.mustBeNullOrMatchEnumValue(validationSubject.getBefore(), GenderType.class, "before");
            ApiModelValidator.mustBeNullOrMatchEnumValue(validationSubject.getAfter(), GenderType.class, "after");
            ApiModelValidator.cannotBeNullOrWhitespace(validationSubject.getActorName(), "actorName");
        };
    }

    @Override
    public boolean canHandle(String messageType) {
        return SUPPORTED_MESSAGE_TYPE.equals(messageType);
    }

    @Override
    public void handle(String messageType, Message message) throws Exception {
        GenderChangedNotificationDto dto = this.messageToDtoConverter.convert(message);
        this.dtoValidator.validate(dto, "dto");
        GenderChangedNotification model = GenderChangedNotificationDtoToModelConverter.convert(dto);
        this.notificationHandler.handle(model);
    }

    public String toString() {
        return MessageHandlerExtensions.fullNameWithMessageType(this, SUPPORTED_MESSAGE_TYPE);
    }
}

